<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$status = isset($_GET['status']) ? $_GET['status'] : '';
$search = isset($_GET['search']) ? $_GET['search'] : '';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';

// Build query
$sql = "SELECT d.*, u.username, u.email, a.name as admin_name 
        FROM deposits d 
        LEFT JOIN users u ON d.user_id = u.id 
        LEFT JOIN admins a ON d.confirmed_by = a.id 
        WHERE 1=1";

if ($status) {
    $sql .= " AND d.status = '$status'";
}

if ($search) {
    $sql .= " AND (u.username LIKE '%$search%' OR u.email LIKE '%$search%' OR d.transaction_hash LIKE '%$search%')";
}

if ($date_from && $date_to) {
    $sql .= " AND DATE(d.created_at) BETWEEN '$date_from' AND '$date_to'";
} elseif ($date_from) {
    $sql .= " AND DATE(d.created_at) >= '$date_from'";
} elseif ($date_to) {
    $sql .= " AND DATE(d.created_at) <= '$date_to'";
}

$sql .= " ORDER BY d.id DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="deposits_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'User', 'Email', 'Amount', 'Status', 'Transaction Hash', 'Created Date', 'Confirmed By', 'Confirmed Date', 'Note'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, array(
            $row['id'],
            $row['username'],
            $row['email'],
            $row['amount'],
            $row['status'],
            $row['transaction_hash'],
            $row['created_at'],
            $row['admin_name'],
            $row['confirmed_at'],
            $row['note']
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="deposits_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>User</th>';
    echo '<th>Email</th>';
    echo '<th>Amount</th>';
    echo '<th>Status</th>';
    echo '<th>Transaction Hash</th>';
    echo '<th>Created Date</th>';
    echo '<th>Confirmed By</th>';
    echo '<th>Confirmed Date</th>';
    echo '<th>Note</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . $row['username'] . '</td>';
        echo '<td>' . $row['email'] . '</td>';
        echo '<td>' . $row['amount'] . '</td>';
        echo '<td>' . $row['status'] . '</td>';
        echo '<td>' . $row['transaction_hash'] . '</td>';
        echo '<td>' . $row['created_at'] . '</td>';
        echo '<td>' . $row['admin_name'] . '</td>';
        echo '<td>' . $row['confirmed_at'] . '</td>';
        echo '<td>' . $row['note'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($format == 'pdf') {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="deposits_' . date('Y-m-d') . '.pdf"');
    
    $html = '<h1>Deposits Report</h1>';
    $html .= '<p>Generated on: ' . date('Y-m-d H:i:s') . '</p>';
    if ($status) $html .= '<p>Status: ' . ucfirst($status) . '</p>';
    if ($date_from || $date_to) $html .= '<p>Date Range: ' . $date_from . ' to ' . $date_to . '</p>';
    
    $html .= '<table border="1" cellpadding="5" cellspacing="0">';
    $html .= '<tr>';
    $html .= '<th>ID</th>';
    $html .= '<th>User</th>';
    $html .= '<th>Amount</th>';
    $html .= '<th>Status</th>';
    $html .= '<th>Created Date</th>';
    $html .= '<th>Confirmed By</th>';
    $html .= '</tr>';
    
    $total = 0;
    while ($row = mysqli_fetch_assoc($result)) {
        $html .= '<tr>';
        $html .= '<td>' . $row['id'] . '</td>';
        $html .= '<td>' . $row['username'] . '</td>';
        $html .= '<td>$' . $row['amount'] . '</td>';
        $html .= '<td>' . $row['status'] . '</td>';
        $html .= '<td>' . $row['created_at'] . '</td>';
        $html .= '<td>' . $row['admin_name'] . '</td>';
        $html .= '</tr>';
        $total += $row['amount'];
    }
    
    $html .= '</table>';
    $html .= '<p style="margin-top: 20px;"><strong>Total Amount: $' . number_format($total, 2) . '</strong></p>';
    
    echo $html;
}
?>