<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$status = isset($_GET['status']) ? $_GET['status'] : '';
$type = isset($_GET['type']) ? $_GET['type'] : '';
$rating = isset($_GET['rating']) ? intval($_GET['rating']) : 0;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';

// Build query
$sql = "SELECT f.*, u.username, u.email 
        FROM feedback f 
        LEFT JOIN users u ON f.user_id = u.id 
        WHERE 1=1";

if ($status) {
    $sql .= " AND f.status = '$status'";
}

if ($type) {
    $sql .= " AND f.type = '$type'";
}

if ($rating > 0) {
    $sql .= " AND f.rating = $rating";
}

if ($search) {
    $sql .= " AND (f.subject LIKE '%$search%' OR f.message LIKE '%$search%' OR u.username LIKE '%$search%' OR u.email LIKE '%$search%')";
}

if ($date_from) {
    $sql .= " AND DATE(f.created_at) >= '$date_from'";
}

if ($date_to) {
    $sql .= " AND DATE(f.created_at) <= '$date_to'";
}

$sql .= " ORDER BY f.created_at DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="feedback_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'User', 'Email', 'Subject', 'Type', 'Rating', 'Status', 'Message', 'Created Date'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        $message = substr(strip_tags($row['message']), 0, 200); // Limit message length
        fputcsv($output, array(
            $row['id'],
            $row['username'] ?: $row['name'],
            $row['email'],
            $row['subject'],
            $row['type'],
            $row['rating'],
            $row['status'],
            $message,
            $row['created_at']
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="feedback_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>User</th>';
    echo '<th>Email</th>';
    echo '<th>Subject</th>';
    echo '<th>Type</th>';
    echo '<th>Rating</th>';
    echo '<th>Status</th>';
    echo '<th>Message</th>';
    echo '<th>Created Date</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        $message = substr(strip_tags($row['message']), 0, 200); // Limit message length
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . ($row['username'] ?: $row['name']) . '</td>';
        echo '<td>' . $row['email'] . '</td>';
        echo '<td>' . $row['subject'] . '</td>';
        echo '<td>' . $row['type'] . '</td>';
        echo '<td>' . $row['rating'] . '</td>';
        echo '<td>' . $row['status'] . '</td>';
        echo '<td>' . $message . '</td>';
        echo '<td>' . $row['created_at'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($format == 'pdf') {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="feedback_' . date('Y-m-d') . '.pdf"');
    
    $html = '<h1>Feedback Report</h1>';
    $html .= '<p>Generated on: ' . date('Y-m-d H:i:s') . '</p>';
    $html .= '<p>Filters: Status=' . $status . ', Type=' . $type . ', Rating=' . ($rating > 0 ? $rating : 'All') . '</p>';
    $html .= '<table border="1" cellpadding="5" cellspacing="0">';
    $html .= '<tr>';
    $html .= '<th>ID</th>';
    $html .= '<th>User</th>';
    $html .= '<th>Subject</th>';
    $html .= '<th>Type</th>';
    $html .= '<th>Rating</th>';
    $html .= '<th>Status</th>';
    $html .= '<th>Date</th>';
    $html .= '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        $html .= '<tr>';
        $html .= '<td>' . $row['id'] . '</td>';
        $html .= '<td>' . ($row['username'] ?: $row['name']) . '</td>';
        $html .= '<td>' . $row['subject'] . '</td>';
        $html .= '<td>' . $row['type'] . '</td>';
        $html .= '<td>' . $row['rating'] . '</td>';
        $html .= '<td>' . $row['status'] . '</td>';
        $html .= '<td>' . date('M d, Y', strtotime($row['created_at'])) . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    
    echo $html;
}
?>