<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$status = isset($_GET['status']) ? $_GET['status'] : '';
$plan = isset($_GET['plan']) ? intval($_GET['plan']) : 0;
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Build query
$sql = "SELECT s.*, u.username, u.email, p.plan_name, p.subscription_fee, p.daily_roi_percentage
        FROM user_bot_subscriptions s
        LEFT JOIN users u ON s.user_id = u.id
        LEFT JOIN trading_bot_plans p ON s.bot_plan_id = p.id
        WHERE 1=1";

if ($status) {
    $sql .= " AND s.status = '$status'";
}

if ($plan > 0) {
    $sql .= " AND s.bot_plan_id = $plan";
}

if ($search) {
    $sql .= " AND (u.username LIKE '%$search%' OR u.email LIKE '%$search%' OR p.plan_name LIKE '%$search%')";
}

$sql .= " ORDER BY s.id DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="bot_subscriptions_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'User', 'Email', 'Plan', 'Trading Balance', 'Total Profit', 'Status', 'Start Date', 'End Date', 'Auto Renew', 'Created Date'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, array(
            $row['id'],
            $row['username'],
            $row['email'],
            $row['plan_name'],
            $row['trading_balance'],
            $row['total_profit'],
            $row['status'],
            $row['subscription_start'],
            $row['subscription_end'],
            $row['auto_renew'] ? 'Yes' : 'No',
            $row['created_at']
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="bot_subscriptions_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>User</th>';
    echo '<th>Email</th>';
    echo '<th>Plan</th>';
    echo '<th>Trading Balance</th>';
    echo '<th>Total Profit</th>';
    echo '<th>Status</th>';
    echo '<th>Start Date</th>';
    echo '<th>End Date</th>';
    echo '<th>Auto Renew</th>';
    echo '<th>Created Date</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . $row['username'] . '</td>';
        echo '<td>' . $row['email'] . '</td>';
        echo '<td>' . $row['plan_name'] . '</td>';
        echo '<td>' . $row['trading_balance'] . '</td>';
        echo '<td>' . $row['total_profit'] . '</td>';
        echo '<td>' . $row['status'] . '</td>';
        echo '<td>' . $row['subscription_start'] . '</td>';
        echo '<td>' . $row['subscription_end'] . '</td>';
        echo '<td>' . ($row['auto_renew'] ? 'Yes' : 'No') . '</td>';
        echo '<td>' . $row['created_at'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($format == 'pdf') {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="bot_subscriptions_' . date('Y-m-d') . '.pdf"');
    
    $html = '<h1>Bot Subscriptions Report</h1>';
    $html .= '<p>Generated on: ' . date('Y-m-d H:i:s') . '</p>';
    $html .= '<table border="1" cellpadding="5" cellspacing="0">';
    $html .= '<tr>';
    $html .= '<th>ID</th>';
    $html .= '<th>User</th>';
    $html .= '<th>Plan</th>';
    $html .= '<th>Balance</th>';
    $html .= '<th>Profit</th>';
    $html .= '<th>Status</th>';
    $html .= '<th>Period</th>';
    $html .= '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        $period = date('M d', strtotime($row['subscription_start'])) . ' - ' . date('M d', strtotime($row['subscription_end']));
        $html .= '<tr>';
        $html .= '<td>' . $row['id'] . '</td>';
        $html .= '<td>' . $row['username'] . '</td>';
        $html .= '<td>' . $row['plan_name'] . '</td>';
        $html .= '<td>$' . $row['trading_balance'] . '</td>';
        $html .= '<td>$' . $row['total_profit'] . '</td>';
        $html .= '<td>' . $row['status'] . '</td>';
        $html .= '<td>' . $period . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    
    echo $html;
}
?>