<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$type = isset($_GET['type']) ? $_GET['type'] : '';
$status = isset($_GET['status']) ? $_GET['status'] : '';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Build query
$sql = "SELECT t.*, u.username, u.email 
        FROM transactions t 
        LEFT JOIN users u ON t.user_id = u.id 
        WHERE 1=1";

if ($type) {
    $sql .= " AND t.type = '$type'";
}

if ($status) {
    $sql .= " AND t.status = '$status'";
}

if ($date_from) {
    $sql .= " AND DATE(t.date) >= '$date_from'";
}

if ($date_to) {
    $sql .= " AND DATE(t.date) <= '$date_to'";
}

if ($search) {
    $sql .= " AND (u.username LIKE '%$search%' OR u.email LIKE '%$search%' OR t.description LIKE '%$search%' OR t.reference_id LIKE '%$search%')";
}

$sql .= " ORDER BY t.id DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="transactions_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'User', 'Email', 'Type', 'Amount', 'Fee', 'Net Amount', 'Status', 'Currency', 'Description', 'Reference ID', 'Date', 'Created At'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, array(
            $row['id'],
            $row['username'],
            $row['email'],
            $row['type'],
            $row['amount'],
            $row['fee'],
            $row['net_amount'],
            $row['status'],
            $row['currency'],
            $row['description'],
            $row['reference_id'],
            $row['date'],
            $row['created_at']
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="transactions_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>User</th>';
    echo '<th>Email</th>';
    echo '<th>Type</th>';
    echo '<th>Amount</th>';
    echo '<th>Fee</th>';
    echo '<th>Net Amount</th>';
    echo '<th>Status</th>';
    echo '<th>Currency</th>';
    echo '<th>Description</th>';
    echo '<th>Reference ID</th>';
    echo '<th>Date</th>';
    echo '<th>Created At</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . $row['username'] . '</td>';
        echo '<td>' . $row['email'] . '</td>';
        echo '<td>' . $row['type'] . '</td>';
        echo '<td>' . $row['amount'] . '</td>';
        echo '<td>' . $row['fee'] . '</td>';
        echo '<td>' . $row['net_amount'] . '</td>';
        echo '<td>' . $row['status'] . '</td>';
        echo '<td>' . $row['currency'] . '</td>';
        echo '<td>' . $row['description'] . '</td>';
        echo '<td>' . $row['reference_id'] . '</td>';
        echo '<td>' . $row['date'] . '</td>';
        echo '<td>' . $row['created_at'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($format == 'pdf') {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="transactions_' . date('Y-m-d') . '.pdf"');
    
    $html = '<h1>Transactions Report</h1>';
    $html .= '<p>Generated on: ' . date('Y-m-d H:i:s') . '</p>';
    $html .= '<table border="1" cellpadding="5" cellspacing="0">';
    $html .= '<tr>';
    $html .= '<th>ID</th>';
    $html .= '<th>User</th>';
    $html .= '<th>Type</th>';
    $html .= '<th>Amount</th>';
    $html .= '<th>Status</th>';
    $html .= '<th>Date</th>';
    $html .= '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        $html .= '<tr>';
        $html .= '<td>' . $row['id'] . '</td>';
        $html .= '<td>' . $row['username'] . '</td>';
        $html .= '<td>' . $row['type'] . '</td>';
        $html .= '<td>$' . $row['amount'] . '</td>';
        $html .= '<td>' . $row['status'] . '</td>';
        $html .= '<td>' . $row['date'] . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    
    echo $html;
}
?>