<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$status = isset($_GET['status']) ? $_GET['status'] : '';
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Build query
$sql = "SELECT * FROM users WHERE 1=1";

if ($status) {
    $sql .= " AND status = '$status'";
}

if ($search) {
    $sql .= " AND (username LIKE '%$search%' OR email LIKE '%$search%' OR first_name LIKE '%$search%' OR last_name LIKE '%$search%')";
}

$sql .= " ORDER BY id DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="users_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'Username', 'Email', 'First Name', 'Last Name', 'Phone', 'Status', 'Fund Balance', 'Available Balance', 'Total Profit', 'Registration Date'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, array(
            $row['id'],
            $row['username'],
            $row['email'],
            $row['first_name'],
            $row['last_name'],
            $row['phone'],
            $row['status'],
            $row['fund_balance'],
            $row['available_balance'],
            $row['total_profit'],
            $row['registration_date']
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="users_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>Username</th>';
    echo '<th>Email</th>';
    echo '<th>First Name</th>';
    echo '<th>Last Name</th>';
    echo '<th>Phone</th>';
    echo '<th>Status</th>';
    echo '<th>Fund Balance</th>';
    echo '<th>Available Balance</th>';
    echo '<th>Total Profit</th>';
    echo '<th>Registration Date</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . $row['username'] . '</td>';
        echo '<td>' . $row['email'] . '</td>';
        echo '<td>' . $row['first_name'] . '</td>';
        echo '<td>' . $row['last_name'] . '</td>';
        echo '<td>' . $row['phone'] . '</td>';
        echo '<td>' . $row['status'] . '</td>';
        echo '<td>' . $row['fund_balance'] . '</td>';
        echo '<td>' . $row['available_balance'] . '</td>';
        echo '<td>' . $row['total_profit'] . '</td>';
        echo '<td>' . $row['registration_date'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($format == 'pdf') {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="users_' . date('Y-m-d') . '.pdf"');
    
    $html = '<h1>Users Report</h1>';
    $html .= '<p>Generated on: ' . date('Y-m-d H:i:s') . '</p>';
    $html .= '<table border="1" cellpadding="5" cellspacing="0">';
    $html .= '<tr>';
    $html .= '<th>ID</th>';
    $html .= '<th>Username</th>';
    $html .= '<th>Email</th>';
    $html .= '<th>Status</th>';
    $html .= '<th>Balance</th>';
    $html .= '<th>Joined</th>';
    $html .= '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        $html .= '<tr>';
        $html .= '<td>' . $row['id'] . '</td>';
        $html .= '<td>' . $row['username'] . '</td>';
        $html .= '<td>' . $row['email'] . '</td>';
        $html .= '<td>' . $row['status'] . '</td>';
        $html .= '<td>$' . $row['fund_balance'] . '</td>';
        $html .= '<td>' . $row['registration_date'] . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    
    echo $html;
}
?>