<?php
// Function to log admin activities
function logAdminActivity($action, $description, $module = null, $affected_id = null, $affected_table = null) {
    global $conn;
    
    // Get admin info from session
    $admin_id = $_SESSION['admin_id'] ?: 1;
    $admin_name = $_SESSION['admin_name'] ?: 'System';
    $admin_role = $_SESSION['admin_role'] ?: 'admin';
    $ip_address = $_SERVER['REMOTE_ADDR'] ?: '';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?: '';
    
    // Insert into admin_activities table
    $sql = "INSERT INTO admin_activities (admin_id, admin_name, admin_role, action, description, module, ip_address, user_agent, affected_id, affected_table, created_at) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
    
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'isssssssis', $admin_id, $admin_name, $admin_role, $action, $description, $module, $ip_address, $user_agent, $affected_id, $affected_table);
    
    return mysqli_stmt_execute($stmt);
}

// Function to get admin name by ID
function getAdminName($admin_id) {
    global $conn;
    
    $sql = "SELECT name FROM admins WHERE id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'i', $admin_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if ($row = mysqli_fetch_assoc($result)) {
        return $row['name'];
    }
    
    return 'Unknown Admin';
}
?>