<script>
	// Idle Timeout Configuration
const IDLE_TIMEOUT = 25 * 60 * 1000; // 25 minutes (5 minutes before PHP timeout)
const WARNING_TIMEOUT = 20 * 60 * 1000; // 20 minutes (show warning)
let idleTimer;
let warningTimer;
let isLocked = false;

// Events that reset idle timer
const events = ['mousemove', 'keydown', 'click', 'scroll', 'touchstart'];

// Initialize idle detection
function initIdleDetection() {
    resetIdleTimer();
    
    // Add event listeners
    events.forEach(event => {
        document.addEventListener(event, resetIdleTimer, true);
    });
    
    // Handle visibility change
    document.addEventListener('visibilitychange', function() {
        if (document.hidden) {
            // Tab is hidden, might want to count this as idle faster
            console.log('Tab hidden - idle detection active');
        } else {
            resetIdleTimer();
        }
    });
}

// Reset idle timer
function resetIdleTimer() {
    clearTimeout(idleTimer);
    clearTimeout(warningTimer);
    
    // Set warning timer
    warningTimer = setTimeout(showIdleWarning, WARNING_TIMEOUT);
    
    // Set idle timer
    idleTimer = setTimeout(lockScreen, IDLE_TIMEOUT);
}

// Show idle warning
function showIdleWarning() {
    if (isLocked) return;
    
    // Check if we're not already on lock screen or login
    const currentPage = window.location.pathname;
    if (currentPage.includes('lock_screen.php') || currentPage.includes('login.php')) {
        return;
    }
    
    // Create warning modal
    const warningModal = document.createElement('div');
    warningModal.id = 'idleWarning';
    warningModal.style.cssText = `
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.8);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 9999;
        backdrop-filter: blur(10px);
    `;
    
    warningModal.innerHTML = `
        <div style="
            background: linear-gradient(135deg, #1a1a2e, #16213e);
            border-radius: 20px;
            padding: 40px;
            max-width: 500px;
            width: 90%;
            text-align: center;
            border: 1px solid rgba(102, 126, 234, 0.3);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.5);
            animation: pulse 2s infinite;
        ">
            <div style="
                width: 80px;
                height: 80px;
                margin: 0 auto 25px;
                border-radius: 50%;
                background: linear-gradient(45deg, #ff9800, #ff5722);
                display: flex;
                align-items: center;
                justify-content: center;
                border: 3px solid rgba(255, 152, 0, 0.3);
            ">
                <i class="fas fa-clock" style="font-size: 36px; color: white;"></i>
            </div>
            <h3 style="color: white; margin-bottom: 10px;">Session Timeout Warning</h3>
            <p style="color: rgba(255, 255, 255, 0.7); margin-bottom: 25px;">
                Your session will expire in 5 minutes due to inactivity.
            </p>
            <div style="
                width: 100%;
                height: 6px;
                background: rgba(255, 255, 255, 0.1);
                border-radius: 3px;
                margin-bottom: 30px;
                overflow: hidden;
            ">
                <div id="countdownBar" style="
                    width: 100%;
                    height: 100%;
                    background: linear-gradient(90deg, #ff9800, #ff5722);
                    border-radius: 3px;
                    transition: width 1s linear;
                "></div>
            </div>
            <div style="display: flex; gap: 15px;">
                <button id="stayLoggedIn" style="
                    flex: 1;
                    padding: 15px;
                    background: linear-gradient(45deg, #667eea, #764ba2);
                    border: none;
                    border-radius: 10px;
                    color: white;
                    font-weight: 600;
                    cursor: pointer;
                    transition: all 0.3s;
                ">
                    <i class="fas fa-check me-2"></i> Stay Logged In
                </button>
                <button id="lockNow" style="
                    flex: 1;
                    padding: 15px;
                    background: rgba(255, 255, 255, 0.1);
                    border: 1px solid rgba(255, 255, 255, 0.2);
                    border-radius: 10px;
                    color: white;
                    font-weight: 600;
                    cursor: pointer;
                    transition: all 0.3s;
                ">
                    <i class="fas fa-lock me-2"></i> Lock Now
                </button>
            </div>
        </div>
    `;
    
    document.body.appendChild(warningModal);
    
    // Start countdown animation (5 minutes = 300 seconds)
    let timeLeft = 300;
    const countdownBar = document.getElementById('countdownBar');
    const countdownInterval = setInterval(() => {
        timeLeft--;
        countdownBar.style.width = (timeLeft / 300 * 100) + '%';
        
        if (timeLeft <= 0) {
            clearInterval(countdownInterval);
            lockScreen();
        }
    }, 1000);
    
    // Add event listeners
    document.getElementById('stayLoggedIn').addEventListener('click', function() {
        clearInterval(countdownInterval);
        document.body.removeChild(warningModal);
        resetIdleTimer();
        // Notify server we're still active
        fetch('ajax/stay_active.php');
    });
    
    document.getElementById('lockNow').addEventListener('click', function() {
        clearInterval(countdownInterval);
        lockScreen();
    });
    
    // Add CSS animation
    const style = document.createElement('style');
    style.textContent = `
        @keyframes pulse {
            0%, 100% { transform: scale(1); box-shadow: 0 20px 40px rgba(0, 0, 0, 0.5); }
            50% { transform: scale(1.02); box-shadow: 0 25px 50px rgba(0, 0, 0, 0.6); }
        }
    `;
    document.head.appendChild(style);
}

// Lock screen
function lockScreen() {
    if (isLocked) return;
    
    isLocked = true;
    
    // Remove warning if it exists
    const warning = document.getElementById('idleWarning');
    if (warning) {
        document.body.removeChild(warning);
    }
    
    // Redirect to lock screen
    window.location.href = 'lock_screen.php';
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', initIdleDetection);

// Export functions for manual control
window.idleDetector = {
    reset: resetIdleTimer,
    lock: lockScreen,
    showWarning: showIdleWarning
};
</script>

<!-- Lock Screen Keyboard Shortcut -->

<script>
// Ctrl + Alt + L to lock screen
document.addEventListener('keydown', function(e) {
    if (e.ctrlKey && e.altKey && e.key === 'l') {
        e.preventDefault();
        if (confirm('Lock the admin dashboard?')) {
            window.location.href = 'lock_screen.php';
        }
    }
});
</script>


<!-- Vendor JS -->
		<script src="js/vendors.min.js"></script>
		<script src="js/pages/chat-popup.js"></script>
		<script src="../assets/icons/feather-icons/feather.min.js"></script>

		<script src="../assets/vendor_components/apexcharts-bundle/dist/apexcharts.js"></script>
		<script src="../assets/vendor_components/jquery.peity/jquery.peity.js"></script>
		<script src="../assets/vendor_components/c3/d3.min.js"></script>
    	<script src="../assets/vendor_components/c3/c3.min.js"></script>
		
		<!-- Etikto Admin App -->
		<script src="js/template.js"></script>
		<script src="js/pages/dashboard7.js"></script>
		<script src="js/pages/calendar.js"></script>