<?php
session_start();

// Check if already logged in
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: index.php');
    exit();
}

// Database connection
include('includes/config.php');

$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $password = md5($_POST['password']); // MD5 as requested
    
    // Check admin credentials
    $sql = "SELECT * FROM admins WHERE email = '$email' AND password = '$password' AND is_active = 1";
    $result = mysqli_query($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) {
        $admin = mysqli_fetch_assoc($result);
        
        // Store admin info in session (without PIN confirmation yet)
        $_SESSION['admin_temp_id'] = $admin['id'];
        $_SESSION['admin_temp_name'] = $admin['name'];
        $_SESSION['admin_temp_email'] = $admin['email'];
        $_SESSION['admin_temp_role'] = $admin['role'];
        $_SESSION['login_attempts'] = 0; // Reset login attempts
        
        // Redirect to PIN confirmation page
        header('Location: login_pin.php');
        exit();
    } else {
        $error = "Invalid email or password!";
        
        // Track failed attempts
        if (!isset($_SESSION['login_attempts'])) {
            $_SESSION['login_attempts'] = 1;
        } else {
            $_SESSION['login_attempts']++;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="../images/favicon.ico">

    <title>AI Trading - 8D Admin Login</title>
  
	<!-- Vendors Style-->
	<link rel="stylesheet" href="css/vendors_css.css">
	  
	<!-- Style-->  
	<link rel="stylesheet" href="css/style.css">
	<link rel="stylesheet" href="css/skin_color.css">
	
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
	
	<!-- SweetAlert2 -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
	
	<!-- Three.js for 3D Background -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
	
	<style>
    * {
        -webkit-tap-highlight-color: transparent;
    }
    
    body {
        margin: 0;
        padding: 0;
        overflow: hidden;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: linear-gradient(-45deg, #0f0c29, #302b63, #24243e, #000428, #0f0c29);
        background-size: 400% 400%;
        animation: gradientBG 15s ease infinite;
        height: 100vh;
        width: 100vw;
        position: fixed;
        touch-action: manipulation;
    }
    
    @keyframes gradientBG {
        0% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
        100% { background-position: 0% 50%; }
    }
    
    #bg3d {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -2;
        opacity: 0.3;
    }
    
    .gradient-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: 
            radial-gradient(circle at 20% 50%, rgba(102, 126, 234, 0.2) 0%, transparent 50%),
            radial-gradient(circle at 80% 20%, rgba(67, 233, 123, 0.15) 0%, transparent 50%),
            radial-gradient(circle at 40% 80%, rgba(255, 107, 107, 0.15) 0%, transparent 50%),
            radial-gradient(circle at 60% 30%, rgba(250, 112, 154, 0.1) 0%, transparent 50%),
            radial-gradient(circle at 30% 70%, rgba(76, 201, 240, 0.1) 0%, transparent 50%);
        z-index: -1;
        animation: pulseOverlay 10s ease-in-out infinite alternate;
    }
    
    @keyframes pulseOverlay {
        0% { 
            opacity: 0.7;
            filter: hue-rotate(0deg);
        }
        100% { 
            opacity: 1;
            filter: hue-rotate(360deg);
        }
    }
    
    .login-container {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1000;
        padding: 20px;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    .login-box {
        background: rgba(255, 255, 255, 0.08);
        backdrop-filter: blur(25px) saturate(180%);
        -webkit-backdrop-filter: blur(25px) saturate(180%);
        border-radius: 30px;
        padding: 40px;
        width: 100%;
        max-width: 450px;
        text-align: center;
        border: 1px solid rgba(255, 255, 255, 0.15);
        box-shadow: 
            0 25px 45px rgba(0, 0, 0, 0.6),
            0 0 100px rgba(102, 126, 234, 0.2),
            inset 0 0 100px rgba(255, 255, 255, 0.05);
        animation: float 6s ease-in-out infinite;
        position: relative;
        z-index: 1002;
        margin: auto;
    }
    
    @keyframes float {
        0%, 100% { 
            transform: translateY(0px) rotateX(0deg); 
            box-shadow: 
                0 25px 45px rgba(0, 0, 0, 0.6),
                0 0 100px rgba(102, 126, 234, 0.2),
                inset 0 0 100px rgba(255, 255, 255, 0.05);
        }
        50% { 
            transform: translateY(-15px) rotateX(2deg); 
            box-shadow: 
                0 35px 55px rgba(0, 0, 0, 0.7),
                0 0 150px rgba(102, 126, 234, 0.3),
                inset 0 0 120px rgba(255, 255, 255, 0.08);
        }
    }
    
    .logo-container {
        margin-bottom: 30px;
        position: relative;
    }
    
    .logo-3d {
        width: 120px;
        height: 120px;
        margin: 0 auto 20px;
        position: relative;
        transform-style: preserve-3d;
        animation: rotate3D 20s infinite linear;
    }
    
    @keyframes rotate3D {
        0% { transform: rotateY(0deg) rotateX(10deg); }
        100% { transform: rotateY(360deg) rotateX(10deg); }
    }
    
    .logo-face {
        position: absolute;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, #667eea, #764ba2, #f093fb);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 3px solid rgba(255, 255, 255, 0.3);
        box-shadow: 
            inset 0 0 30px rgba(255, 255, 255, 0.3),
            0 0 40px rgba(102, 126, 234, 0.5);
    }
    
    .logo-face i {
        font-size: 50px;
        color: white;
        text-shadow: 0 0 20px rgba(255, 255, 255, 0.5);
    }
    
    .logo-text {
        margin-top: 20px;
    }
    
    .logo-text h1 {
        color: white;
        margin: 0;
        font-size: 28px;
        font-weight: 700;
        background: linear-gradient(45deg, #fff, #a8edea);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        text-shadow: 0 0 30px rgba(168, 237, 234, 0.3);
        letter-spacing: 1px;
    }
    
    .logo-text p {
        color: rgba(255, 255, 255, 0.7);
        margin: 5px 0 0;
        font-size: 14px;
        letter-spacing: 0.5px;
    }
    
    .form-group {
        margin-bottom: 25px;
        text-align: left;
    }
    
    .form-label {
        display: block;
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 8px;
        font-size: 14px;
        font-weight: 500;
        letter-spacing: 0.5px;
    }
    
    .input-3d {
        position: relative;
    }
    
    .input-3d input {
        width: 100%;
        padding: 18px 20px;
        background: rgba(255, 255, 255, 0.07);
        border: 2px solid rgba(255, 255, 255, 0.15);
        border-radius: 15px;
        color: white;
        font-size: 16px;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        box-sizing: border-box;
        -webkit-appearance: none;
        appearance: none;
        font-weight: 500;
        letter-spacing: 0.5px;
    }
    
    .input-3d input:focus {
        outline: none;
        border-color: #667eea;
        background: rgba(255, 255, 255, 0.12);
        box-shadow: 
            0 0 25px rgba(102, 126, 234, 0.4),
            inset 0 0 20px rgba(102, 126, 234, 0.1);
        transform: translateY(-2px);
    }
    
    .input-3d i {
        position: absolute;
        right: 20px;
        top: 50%;
        transform: translateY(-50%);
        color: rgba(255, 255, 255, 0.5);
        font-size: 18px;
        transition: all 0.3s;
    }
    
    .input-3d input:focus + i {
        color: #667eea;
        text-shadow: 0 0 10px rgba(102, 126, 234, 0.5);
    }
    
    .btn-3d {
        width: 100%;
        padding: 18px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
        border: none;
        border-radius: 15px;
        color: white;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        overflow: hidden;
        box-sizing: border-box;
        letter-spacing: 1px;
        text-transform: uppercase;
        box-shadow: 
            0 10px 30px rgba(102, 126, 234, 0.4),
            inset 0 1px 0 rgba(255, 255, 255, 0.2);
    }
    
    .btn-3d:hover {
        transform: translateY(-3px) scale(1.02);
        box-shadow: 
            0 15px 40px rgba(102, 126, 234, 0.5),
            inset 0 1px 0 rgba(255, 255, 255, 0.3);
        background: linear-gradient(135deg, #764ba2 0%, #f093fb 50%, #667eea 100%);
    }
    
    .btn-3d:active {
        transform: translateY(-1px) scale(0.98);
    }
    
    .btn-3d:disabled {
        opacity: 0.5;
        cursor: not-allowed;
        transform: none !important;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2) !important;
    }
    
    .error-message {
        background: rgba(255, 107, 107, 0.15);
        border: 1px solid rgba(255, 107, 107, 0.3);
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 20px;
        color: #ff6b6b;
        text-align: left;
        font-size: 14px;
        animation: shake 0.5s ease-in-out;
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
    }
    
    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        25% { transform: translateX(-5px); }
        75% { transform: translateX(5px); }
    }
    
    .warning-message {
        background: rgba(255, 193, 7, 0.15);
        border: 1px solid rgba(255, 193, 7, 0.3);
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 20px;
        color: #ffc107;
        text-align: left;
        font-size: 14px;
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
    }
    
    .captcha-3d {
        background: rgba(255, 255, 255, 0.07);
        border: 2px solid rgba(255, 255, 255, 0.15);
        border-radius: 15px;
        padding: 20px;
        margin-bottom: 25px;
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        transition: all 0.3s;
    }
    
    .captcha-3d:hover {
        border-color: rgba(102, 126, 234, 0.5);
        box-shadow: 0 0 20px rgba(102, 126, 234, 0.2);
    }
    
    #captchaCode {
        font-size: 24px;
        font-weight: 700;
        letter-spacing: 15px;
        color: white;
        background: linear-gradient(45deg, #667eea, #f093fb);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        text-align: center;
        padding: 10px;
        margin-bottom: 15px;
        user-select: none;
        text-shadow: 0 0 20px rgba(102, 126, 234, 0.3);
    }
    
    .remember-forgot {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin: 25px 0;
    }
    
    .checkbox-3d {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .checkbox-3d input {
        width: 18px;
        height: 18px;
        accent-color: #667eea;
        cursor: pointer;
    }
    
    .checkbox-3d label {
        color: rgba(255, 255, 255, 0.8);
        font-size: 14px;
        cursor: pointer;
    }
    
    .forgot-link {
        color: #667eea;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s;
    }
    
    .forgot-link:hover {
        color: #f093fb;
        text-shadow: 0 0 10px rgba(240, 147, 251, 0.5);
    }
    
    .security-badge {
        display: inline-block;
        background: rgba(102, 126, 234, 0.2);
        border: 1px solid rgba(102, 126, 234, 0.4);
        border-radius: 20px;
        padding: 8px 20px;
        margin-top: 25px;
        color: rgba(255, 255, 255, 0.9);
        font-size: 12px;
        letter-spacing: 0.5px;
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
    }
    
    .floating-elements {
        position: fixed;
        width: 100%;
        height: 100%;
        pointer-events: none;
        z-index: 1;
    }
    
    .floating-element {
        position: absolute;
        background: rgba(255, 255, 255, 0.05);
        border-radius: 50%;
        animation: floatElement 15s infinite linear;
    }
    
    @keyframes floatElement {
        0% {
            transform: translateY(0) rotate(0deg);
            opacity: 0;
        }
        10% {
            opacity: 1;
        }
        90% {
            opacity: 1;
        }
        100% {
            transform: translateY(-100vh) rotate(360deg);
            opacity: 0;
        }
    }
    
    /* Mobile Responsive */
    @media (max-width: 767px) {
        body {
            background-size: 600% 600%;
        }
        
        .login-container {
            padding: 15px;
            align-items: flex-start;
            padding-top: 60px;
        }
        
        .login-box {
            padding: 30px 25px;
            max-width: 90%;
            margin-top: 0;
            animation: floatMobile 6s ease-in-out infinite;
        }
        
        @keyframes floatMobile {
            0%, 100% { 
                transform: translateY(0px) rotateX(0deg); 
            }
            50% { 
                transform: translateY(-10px) rotateX(1deg); 
            }
        }
        
        .logo-3d {
            width: 100px;
            height: 100px;
        }
        
        .logo-face i {
            font-size: 40px;
        }
        
        .logo-text h1 {
            font-size: 22px;
        }
        
        .logo-text p {
            font-size: 12px;
        }
        
        .input-3d input {
            padding: 16px 15px;
            font-size: 15px;
        }
        
        .btn-3d {
            padding: 16px;
            font-size: 15px;
        }
        
        .captcha-3d {
            padding: 15px;
        }
        
        #captchaCode {
            font-size: 20px;
            letter-spacing: 10px;
        }
    }
    
    @media (max-width: 480px) {
        .login-box {
            max-width: 95%;
            padding: 25px 20px;
        }
        
        .remember-forgot {
            flex-direction: column;
            gap: 15px;
            align-items: flex-start;
        }
    }
    
    /* Loading animation */
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .loading-spinner {
        display: inline-block;
        width: 20px;
        height: 20px;
        border: 2px solid rgba(255, 255, 255, 0.3);
        border-radius: 50%;
        border-top-color: white;
        animation: spin 1s ease-in-out infinite;
    }
    
    /* Custom scrollbar */
    .login-container::-webkit-scrollbar {
        width: 5px;
    }
    
    .login-container::-webkit-scrollbar-track {
        background: rgba(255, 255, 255, 0.05);
        border-radius: 10px;
    }
    
    .login-container::-webkit-scrollbar-thumb {
        background: linear-gradient(45deg, #667eea, #764ba2);
        border-radius: 10px;
    }
    
    /* Disable 3D on mobile for performance */
    @media (max-width: 768px) {
        #bg3d {
            display: none;
        }
        
        .logo-3d {
            animation: none;
        }
    }
    
    /* Touch device optimizations */
    @media (hover: none) and (pointer: coarse) {
        .btn-3d:hover {
            transform: none;
        }
        
        .input-3d input:focus {
            transform: none;
        }
    }
    </style>

</head>
	
<body>
    <!-- 3D Background -->
    <div id="bg3d"></div>
    
    <!-- Gradient Overlay -->
    <div class="gradient-overlay"></div>
    
    <!-- Floating Elements -->
    <div class="floating-elements" id="floatingElements"></div>
    
    <!-- Login Container -->
    <div class="login-container">
        <div class="login-box">
            <!-- 3D Logo -->
            <div class="logo-container">
                <div class="logo-3d">
                    <div class="logo-face">
                        <i class="fas fa-robot"></i>
                    </div>
                </div>
                <div class="logo-text">
                    <h1 class="neon-text">AI TRADING 8D</h1>
                    <p>Quantum Secure Admin Portal</p>
                </div>
            </div>
            
            <?php if ($error): ?>
                <div class="error-message">
                    <i class="fas fa-exclamation-circle me-2"></i> <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($_SESSION['login_attempts']) && $_SESSION['login_attempts'] >= 3): ?>
                <div class="warning-message">
                    <i class="fas fa-shield-alt me-2"></i> Security Lock: Too many failed attempts. Please wait 30 seconds.
                </div>
            <?php endif; ?>
            
            <form action="" method="POST" id="loginForm">
                <!-- Email -->
                <div class="form-group">
                    <label class="form-label"><i class="fas fa-at me-1"></i> QUANTUM EMAIL</label>
                    <div class="input-3d">
                        <input type="email" name="email" placeholder="admin@quantum.ai" required 
                               <?php echo isset($_SESSION['login_attempts']) && $_SESSION['login_attempts'] >= 3 ? 'disabled' : ''; ?>>
                        <i class="fas fa-envelope"></i>
                    </div>
                </div>
                
                <!-- Password -->
                <div class="form-group">
                    <label class="form-label"><i class="fas fa-key me-1"></i> CRYPTO KEY</label>
                    <div class="input-3d">
                        <input type="password" name="password" id="password" placeholder="••••••••••" required 
                               <?php echo isset($_SESSION['login_attempts']) && $_SESSION['login_attempts'] >= 3 ? 'disabled' : ''; ?>>
                        <i class="fas fa-lock"></i>
                        <button type="button" class="btn btn-sm" id="togglePassword" style="position: absolute; right: 50px; top: 50%; transform: translateY(-50%); background: none; border: none; color: rgba(255,255,255,0.5);">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
                
                <!-- CAPTCHA -->
                <div class="captcha-3d">
                    <div class="form-label mb-3"><i class="fas fa-robot me-1"></i> QUANTUM VERIFICATION</div>
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <div id="captchaCode" class="flex-grow-1"></div>
                        <button type="button" class="btn btn-sm btn-outline-light" id="refreshCaptcha">
                            <i class="fas fa-redo"></i>
                        </button>
                    </div>
                    <input type="text" class="form-control bg-transparent text-white border-2 border-light" 
                           id="captchaInput" placeholder="Enter verification code" 
                           <?php echo isset($_SESSION['login_attempts']) && $_SESSION['login_attempts'] >= 3 ? 'disabled' : ''; ?>>
                </div>
                
                <!-- Remember & Forgot -->
                <div class="remember-forgot">
                    <div class="checkbox-3d">
                        <input type="checkbox" id="remember_me" name="remember">
                        <label for="remember_me">Quantum Memory</label>
                    </div>
                    <a href="forgot_password.php" class="forgot-link">
                        <i class="fas fa-unlock-alt me-1"></i> Lost Key?
                    </a>
                </div>
                
                <!-- Submit Button -->
                <button type="submit" class="btn-3d" id="loginBtn" 
                        <?php echo isset($_SESSION['login_attempts']) && $_SESSION['login_attempts'] >= 3 ? 'disabled' : ''; ?>>
                    <span id="btnText">
                        <i class="fas fa-fingerprint me-2"></i> INITIATE QUANTUM AUTH
                    </span>
                    <span id="btnLoading" style="display: none;">
                        <span class="loading-spinner me-2"></span> DECRYPTING...
                    </span>
                </button>
            </form>
            
            <!-- Security Badge -->
            <div class="security-badge">
                <i class="fas fa-shield-alt me-2"></i> 256-bit Quantum Encryption
            </div>
        </div>
    </div>

	<!-- Vendor JS -->
	<script src="js/vendors.min.js"></script>
	<script src="../assets/icons/feather-icons/feather.min.js"></script>
	
	<!-- SweetAlert2 -->
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	
	<script>
	// Initialize 3D background
	function init3DBackground() {
		if (window.innerWidth > 768) { // Only on desktop
			const scene = new THREE.Scene();
			const camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000);
			const renderer = new THREE.WebGLRenderer({ alpha: true, antialias: true });
			renderer.setSize(window.innerWidth, window.innerHeight);
			renderer.setPixelRatio(window.devicePixelRatio);
			document.getElementById('bg3d').appendChild(renderer.domElement);
			
			// Create particles
			const particlesGeometry = new THREE.BufferGeometry();
			const particlesCount = 500;
			const posArray = new Float32Array(particlesCount * 3);
			
			for(let i = 0; i < particlesCount * 3; i++) {
				posArray[i] = (Math.random() - 0.5) * 10;
			}
			
			particlesGeometry.setAttribute('position', new THREE.BufferAttribute(posArray, 3));
			
			// Material
			const particlesMaterial = new THREE.PointsMaterial({
				size: 0.02,
				color: '#667eea',
				transparent: true,
				opacity: 0.6
			});
			
			// Mesh
			const particlesMesh = new THREE.Points(particlesGeometry, particlesMaterial);
			scene.add(particlesMesh);
			
			camera.position.z = 3;
			
			// Animation
			function animate() {
				requestAnimationFrame(animate);
				particlesMesh.rotation.x += 0.001;
				particlesMesh.rotation.y += 0.001;
				renderer.render(scene, camera);
			}
			animate();
			
			// Handle resize
			window.addEventListener('resize', () => {
				camera.aspect = window.innerWidth / window.innerHeight;
				camera.updateProjectionMatrix();
				renderer.setSize(window.innerWidth, window.innerHeight);
			});
		}
	}
	
	// Generate floating elements
	function generateFloatingElements() {
		const container = document.getElementById('floatingElements');
		const colors = ['#667eea', '#764ba2', '#f093fb', '#43e97b', '#4facfe'];
		
		for(let i = 0; i < 20; i++) {
			const element = document.createElement('div');
			element.className = 'floating-element';
			
			// Random properties
			const size = Math.random() * 60 + 20;
			const left = Math.random() * 100;
			const delay = Math.random() * 15;
			const duration = Math.random() * 10 + 15;
			const color = colors[Math.floor(Math.random() * colors.length)];
			
			element.style.width = `${size}px`;
			element.style.height = `${size}px`;
			element.style.left = `${left}%`;
			element.style.background = `radial-gradient(circle, ${color}20 0%, transparent 70%)`;
			element.style.animationDelay = `${delay}s`;
			element.style.animationDuration = `${duration}s`;
			
			container.appendChild(element);
		}
	}
	
	$(document).ready(function() {
		// Initialize 3D and effects
		init3DBackground();
		generateFloatingElements();
		
		// Generate CAPTCHA
		function generateCaptcha() {
			const chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
			let captcha = '';
			for(let i = 0; i < 6; i++) {
				captcha += chars.charAt(Math.floor(Math.random() * chars.length));
			}
			$('#captchaCode').text(captcha);
			return captcha;
		}
		
		let currentCaptcha = generateCaptcha();
		
		// Refresh CAPTCHA
		$('#refreshCaptcha').click(function() {
			currentCaptcha = generateCaptcha();
			$('#captchaInput').val('').focus();
		});
		
		// Toggle password visibility
		$('#togglePassword').click(function() {
			const passwordField = $('#password');
			const type = passwordField.attr('type') === 'password' ? 'text' : 'password';
			passwordField.attr('type', type);
			$(this).find('i').toggleClass('fa-eye fa-eye-slash');
		});
		
		// Form submission
		$('#loginForm').submit(function(e) {
			const captchaInput = $('#captchaInput').val().toUpperCase();
			
			if (captchaInput !== currentCaptcha) {
				e.preventDefault();
				Swal.fire({
					icon: 'error',
					title: 'Quantum Verification Failed',
					text: 'Security code mismatch. Please try again.',
					confirmButtonColor: '#667eea',
					background: 'rgba(15, 12, 41, 0.95)',
					color: 'white',
					customClass: {
						popup: 'border-2 border-light rounded-3'
					}
				});
				currentCaptcha = generateCaptcha();
				$('#captchaInput').val('').focus();
				return false;
			}
			
			// Show loading state
			$('#btnText').hide();
			$('#btnLoading').show();
			$('#loginBtn').prop('disabled', true);
		});
		
		// Handle failed attempts lockout
		const failedAttempts = <?php echo isset($_SESSION['login_attempts']) ? $_SESSION['login_attempts'] : 0; ?>;
		if (failedAttempts >= 3) {
			let timer = 30;
			const btn = $('#loginBtn');
			const interval = setInterval(() => {
				$('#btnText').html(`<i class="fas fa-lock me-2"></i> QUANTUM LOCK: ${timer}s`);
				timer--;
				
				if (timer < 0) {
					clearInterval(interval);
					location.reload();
				}
			}, 1000);
		}
		
		// Add ripple effect to button
		$('.btn-3d').click(function(e) {
			if (!$(this).prop('disabled')) {
				const $btn = $(this);
				const btnOffset = $btn.offset();
				const x = e.pageX - btnOffset.left;
				const y = e.pageY - btnOffset.top;
				
				const $ripple = $('<span class="ripple"></span>');
				$ripple.css({
					position: 'absolute',
					background: 'rgba(255, 255, 255, 0.3)',
					borderRadius: '50%',
					transform: 'scale(0)',
					animation: 'ripple 0.6s linear',
					pointerEvents: 'none',
					left: x,
					top: y,
					width: '100px',
					height: '100px',
					marginLeft: '-50px',
					marginTop: '-50px'
				});
				
				$btn.append($ripple);
				setTimeout(() => $ripple.remove(), 600);
			}
		});
		
		// Add CSS for ripple animation
		const style = document.createElement('style');
		style.textContent = `
			@keyframes ripple {
				to {
					transform: scale(4);
					opacity: 0;
				}
			}
		`;
		document.head.appendChild(style);
	});
	</script>
	
</body>
</html>