<?php 
session_start();
include('includes/head.php');

// Get subscription ID
$subscription_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($subscription_id == 0) {
    header('Location: bot_subscriptions.php');
    exit();
}

// Get subscription details
$sql = "SELECT s.*, u.username, u.email, u.phone, u.fund_balance, p.*
        FROM user_bot_subscriptions s
        LEFT JOIN users u ON s.user_id = u.id
        LEFT JOIN trading_bot_plans p ON s.bot_plan_id = p.id
        WHERE s.id = $subscription_id";
$result = mysqli_query($conn, $sql);
$subscription = mysqli_fetch_assoc($result);

if (!$subscription) {
    header('Location: bot_subscriptions.php');
    exit();
}

// Get subscription transactions
$txn_sql = "SELECT * FROM bot_transactions WHERE subscription_id = $subscription_id ORDER BY created_at DESC LIMIT 20";
$txn_result = mysqli_query($conn, $txn_sql);

// Status colors
$status_colors = array(
    'active' => 'success',
    'pending' => 'warning',
    'expired' => 'danger',
    'cancelled' => 'secondary'
);
?>

<!DOCTYPE html>
<html lang="en">
  	
	
	<body class="hold-transition dark-skin sidebar-mini theme-primary fixed">
		<div class="wrapper">
		  	<?php include('includes/header.php') ?>
		  	<?php include('includes/sidebar.php') ?>
		  	
			<div class="content-wrapper">
				<div class="container-full">
					<section class="content">
						<div class="row">
							<div class="col-12">
								<div class="box">
									<div class="box-header">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h4 class="box-title">
													<i class="fas fa-robot me-2"></i>
													Subscription Details: <?php echo htmlspecialchars($subscription['plan_name']); ?>
												</h4>
												<p class="mb-0 text-mute">Subscription ID: <?php echo $subscription['id']; ?></p>
											</div>
											<div>
												<a href="bot_subscriptions.php" class="btn btn-light me-2">
													<i class="fas fa-arrow-left me-1"></i> Back to Subscriptions
												</a>
											</div>
										</div>
									</div>
									<div class="box-body">
										<!-- Subscription Details would go here -->
										<div class="alert alert-info">
											<h5><i class="fas fa-info-circle me-2"></i>Subscription View Page</h5>
											<p>This page would show detailed subscription information, transaction history, performance analytics, etc.</p>
											<a href="bot_subscriptions.php" class="btn btn-primary">Return to Subscriptions List</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</section>
				</div>
			</div>
		  	
		  	<?php include('includes/footer.php') ?>
		  	<?php include('includes/control_sidebar.php') ?>
		</div>
		
		
		<?php include('includes/scripts.php') ?>
	</body>
</html>