<?php session_start();

?>
<!DOCTYPE html>
<html lang="en">


<?php include("includes/head.php")?>


<body>

    <!--==========================   Preloader Start  ==========================-->
    
    <!--==========================  Preloader End  ==========================-->

    <div class="wrapper">
        <!--==========================   Header Start  ==========================-->
            <?php include("includes/header.php") ?>

        <!--==========================  Header End  ==========================-->
       
       <main>
    <!-- ==================== Breadcrumb Start Here ==================== -->
    <section class="breadcrumb">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="breadcrumb__wrapper">
                        <h2 class="breadcrumb__title">AI Trading Support Contact</h2>
                        <ul class="breadcrumb__list">
                            <li class="breadcrumb__item"><a href="index.php" class="breadcrumb__link"> 
                                <i class="las la-home"></i> Home</a> 
                            </li>
                            <li class="breadcrumb__item"><i class="fa-solid fa-minus"></i></li>
                            <li class="breadcrumb__item"> 
                                <span class="breadcrumb__item-text"> Contact AI Support</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ==================== Breadcrumb End Here ==================== -->
    
    <!--==========================  AI Trading Support Section Start  ==========================-->
    <section class="contact-section bg--black-two py-120">
        <div class="container">
            <div class="row pb-120 row-gap-4 align-items-center">
                <div class="col-lg-5 order-1 order-lg-0">
                    <div class="contact-info">
                        <h3 class="mb-1">24/7 AI Trading Support</h3>
                        <p>Need help with bot setup, funding, or withdrawals? Our AI trading specialists are available 24/7 to assist you.</p>
                        <ul class="d-grid gap-3 mt-4 pt-lg-3">
                            <li class="d-flex gap-2">
                                <div class="icon">
                                    <i class="fa-solid fa-phone-volume"></i>
                                </div>
                                <div>
                                    <p class="mb-1"><strong>Bot Support Hotline</strong></p>
                                    <p><a href="tel:+27821234567">+27 (82) 123 4567</a></p>
                                    <small class="text-muted">Available 24/7 for urgent bot issues</small>
                                </div>
                            </li>
                            <li class="d-flex gap-2">
                                <div class="icon">
                                    <i class="fa-solid fa-envelope"></i>
                                </div>
                                <div>
                                    <p class="mb-1"><strong>Support Email</strong></p>
                                    <p><a href="mailto:support@aitradingplatform.com">support@aitradingplatform.com</a></p>
                                    <small class="text-muted">Response within 2 hours</small>
                                </div>
                            </li>
                            <li class="d-flex gap-2">
                                <div class="icon">
                                    <i class="fa-solid fa-location-dot"></i>
                                </div>
                                <div>
                                    <p class="mb-1"><strong>Headquarters</strong></p>
                                    <p>123 AI Trading Avenue, Sandton, Johannesburg 2196, South Africa</p>
                                    <small class="text-muted">Registered FSP #12345</small>
                                </div>
                            </li>
                            <li class="d-flex gap-2">
                                <div class="icon">
                                    <i class="fa-solid fa-clock"></i>
                                </div>
                                <div>
                                    <p class="mb-1"><strong>Support Hours</strong></p>
                                    <p>24/7/365 Support Available</p>
                                    <small class="text-muted">Live Chat: 9 AM - 11 PM SAST</small>
                                </div>
                            </li>
                        </ul>
                        <h3 class="mb-1 mt-4 pt-lg-4">Quick Support Links</h3>
                        <ul class="quick-links mt-3">
                            <li><a href="faq.php"><i class="fa-solid fa-circle-question me-2"></i> AI Trading FAQs</a></li>
                            <li><a href="support-tickets.php"><i class="fa-solid fa-ticket me-2"></i> Submit Support Ticket</a></li>
                            <li><a href="bot-setup-guide.php"><i class="fa-solid fa-robot me-2"></i> Bot Setup Guide</a></li>
                            <li><a href="withdrawal-help.php"><i class="fa-solid fa-money-bill-transfer me-2"></i> Withdrawal Help</a></li>
                        </ul>
                        <h3 class="mb-1 mt-4 pt-lg-4">Follow Our AI Journey</h3>
                        <ul class="social-icon">
                            <li><a href="https://www.facebook.com/" target="_blank" title="Facebook">
                                <i class="fa-brands fa-facebook-f"></i></a>
                            </li>
                            <li><a href="https://www.instagram.com/" target="_blank" title="Instagram">
                                <i class="fa-brands fa-instagram"></i></a>
                            </li>
                            <li><a href="https://www.linkedin.com/" target="_blank" title="LinkedIn">
                                <i class="fa-brands fa-linkedin-in"></i></a>
                            </li>
                            <li><a href="https://twitter.com/" target="_blank" title="Twitter">
                                <i class="fa-brands fa-x-twitter"></i></a>
                            </li>
                            <li><a href="https://t.me/" target="_blank" title="Telegram">
                                <i class="fa-brands fa-telegram"></i></a>
                            </li>
                            <li><a href="https://www.youtube.com/" target="_blank" title="YouTube">
                                <i class="fa-brands fa-youtube"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="enquiry-form">
                        <h3>AI Trading Support Form</h3>
                        <p class="mb-4">Get help with bot setup, funding issues, withdrawals, or account verification.</p>
                        
                        <form id="contact-form" action="sendmail.php" method="POST">
                            <div class="row row-gap-4">
                                <div class="col-md-6">
                                    <input type="text" name="name" class="form-control" placeholder="Your Full Name" required>
                                </div>
                                <div class="col-md-6">
                                    <input type="email" name="email" class="form-control" placeholder="Email Address" required>
                                </div>
                                <div class="col-md-6">
                                    <input type="tel" name="phone" class="form-control" placeholder="Phone Number" required>
                                </div>
                                <div class="col-md-6">
                                    <select name="support_type" class="form-control" required>
                                        <option value="">Select Support Type</option>
                                        <option value="bot_setup">AI Bot Setup Help</option>
                                        <option value="funding">Deposit/Funding Issues</option>
                                        <option value="withdrawal">Withdrawal Problems</option>
                                        <option value="account">Account Verification</option>
                                        <option value="bot_performance">Bot Performance Questions</option>
                                        <option value="technical">Technical Issues</option>
                                        <option value="general">General Inquiry</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <select name="bot_plan" class="form-control">
                                        <option value="">Select Your Bot Plan (If Applicable)</option>
                                        <option value="ai_alpha">AI Alpha Bot</option>
                                        <option value="ai_sigma">AI Sigma Bot</option>
                                        <option value="ai_quantum">AI Quantum Bot</option>
                                        <option value="ai_omega">AI Omega Bot</option>
                                        <option value="none">Not Subscribed Yet</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <input type="text" name="user_id" class="form-control" placeholder="User ID (If Registered)">
                                </div>
                                <div class="col-md-12">
                                    <textarea name="message" class="form-control" rows="6" placeholder="Describe your issue in detail. Include any error messages or transaction IDs if applicable." required></textarea>
                                </div> 
                                <div class="col-md-12">
                                    <div class="form-check mb-3">
                                        <input type="checkbox" class="form-check-input" id="urgent" name="urgent">
                                        <label class="form-check-label" for="urgent">
                                            <i class="fa-solid fa-triangle-exclamation text-warning me-1"></i>
                                            Mark as Urgent (24/7 phone support will contact you)
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-12"> 
                                    <div class="form-message"></div>
                                    <button type="submit" class="btn btn--base-two">
                                        <i class="fa-solid fa-paper-plane me-2"></i>
                                        Send Support Request
                                    </button>
                                    <small class="d-block mt-2 text-muted">
                                        <i class="fa-solid fa-clock me-1"></i>
                                        Average response time: 15 minutes (Live Chat), 2 hours (Email)
                                    </small>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="contact-map-container">
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3580.207122557761!2d28.04615777594123!3d-26.107244859320615!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1e9573b5d4b5a0a1%3A0x7b8a4d8d8b8d8b8d!2sSandton%2C%20Johannesburg%2C%20South%20Africa!5e0!3m2!1sen!2sza!4v1700000000000!5m2!1sen!2sza"
                            allowfullscreen class="contact-map">
                        </iframe>
                        <div class="map-overlay">
                            <div class="overlay-content">
                                <h4><i class="fa-solid fa-building me-2"></i> AI Trading Headquarters</h4>
                                <p class="mb-1">123 AI Trading Avenue, Sandton</p>
                                <p class="mb-1">Johannesburg 2196, South Africa</p>
                                <p class="mb-0"><i class="fa-solid fa-phone me-1"></i> +27 (82) 123 4567</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  AI Trading Support Section End  ==========================-->
    
    <!--==========================  Call-to-action Section Start  ==========================-->
    <section class="call-to-action-section bg--black-two">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="call-action-box">
                        <div class="call-shape">
                            <img src="assets/svg/twostar.svg" alt="star">
                        </div>
                        <div class="row row-gap-5">
                            <div class="col-lg-6 align-self-center order-1 order-lg-0">
                                <div class="call-text text-center text-lg-start">
                                    <span class="text--base pb-3 right-reveal">Ready to Start AI Trading?</span>
                                    <h2 class="mb-4 right-reveal">Join Thousands Earning Passive Income with Zero Trading Knowledge Required</h2>
                                    <a href="register.php" class="btn btn--base-two right-reveal">
                                        <i class="fa-solid fa-robot me-2"></i>
                                        Start Free Trial
                                    </a>
                                    <p class="mt-3 small">7-day free trial • No credit card required • AI bots do all the work</p>
                                </div>
                            </div>
                            <div class="col-lg-6 align-self-center">
                                <div class="call-img text-lg-end text-center scaleUp">
                                    <img src="assets/images/call/call-img.png" alt="AI Trading Platform" class="img-fluid m-auto">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Call-to-action Section End  ==========================-->
</main>
        <!-- ==================== Footer Start Here ==================== -->
       <?php include("includes/footer.php") ?>
        <!-- ==================== Footer End Here ==================== -->
    </div>
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <style>
        /* Quick Support Links */
.quick-links {
    list-style: none;
    padding: 0;
    margin: 0;
}

.quick-links li {
    margin-bottom: 10px;
}

.quick-links li a {
    color: #fff;
    text-decoration: none;
    display: block;
    padding: 8px 12px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 5px;
    transition: all 0.3s ease;
}

.quick-links li a:hover {
    background: rgba(255, 255, 255, 0.1);
    transform: translateX(5px);
}

/* Map Overlay */
.contact-map-container {
    position: relative;
    border-radius: 10px;
    overflow: hidden;
}

.map-overlay {
    position: absolute;
    top: 20px;
    left: 20px;
    background: rgba(0, 0, 0, 0.8);
    padding: 20px;
    border-radius: 8px;
    max-width: 300px;
}

.overlay-content h4 {
    color: #fff;
    margin-bottom: 10px;
}

.overlay-content p {
    color: #aaa;
    margin-bottom: 5px;
    font-size: 14px;
}

/* Form Improvements */
.form-check-label {
    color: #ccc;
}

.form-check-input:checked {
    background-color: #0d6efd;
    border-color: #0d6efd;
}

/* Urgent Support Styling */
.text-warning {
    color: #ffc107 !important;
}
    </style>


    <!-- Jquery js -->
    <script data-cfasync="false" src="../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- gsap Js -->
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <!-- Bootstrap Bundle Js -->
    <script src="assets/js/boostrap.bundle.min.js"></script>
    <!-- Scroll Reveal Js -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <!-- Swiper Bundle Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Fancy Box js -->
    <script src="assets/js/fancybox.umd.js"></script>
    <!-- Odometer js -->
    <script src="assets/js/odometer.min.js"></script>

    <!-- main js -->
    <script src="assets/js/main.js"></script>
<script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"3c29d7bffb424472bfac70b0302e98df","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>
</body>


<!-- Mirrored from photoclerks.com/html/xtrady-update/xtrady/support.html by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 31 Jan 2026 19:52:33 GMT -->
</html>