<!-- Stubborn KYC Verification Modal -->
<?php if($current_page == 'dashboard.php' || $current_page == 'wallets.php' || $current_page == 'apply_loan.php') {?>
<?php if($kycSubmitted == 0 || $kycSubmitted == 2 || $kyc_verified == '' || $kyc_verified == 'rejected' ) : ?>

<div class="modal fade show" id="autoModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="autoModalLabel" aria-hidden="true" style="display: block; padding-right: 17px;">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content shadow-lg border-0 rounded-4 bg-dark">
      
      <!-- Header -->
      <div class="modal-header bg-danger text-white border-bottom border-warning">
        <h5 class="modal-title fw-bold" id="autoModalLabel">
          <i class="fi fi-rr-shield-exclamation me-2"></i>
          MANDATORY KYC VERIFICATION REQUIRED
          <?php 
            if($kycSubmitted == 2 || $kyc_verified == 'rejected') {
              echo '<span class="badge bg-danger ms-2">KYC Rejected</span>';
            }
          ?>
        </h5>
      </div>

      <!-- Body -->
      <div class="modal-body">

        <div class="alert alert-danger border-danger mb-4">
          <div class="d-flex align-items-center">
            <i class="fi fi-rr-ban me-2 fs-5"></i>
            <div>
              <h6 class="mb-1 fw-bold">ACCESS RESTRICTED</h6>
              <p class="mb-0 small">You cannot proceed without completing KYC verification</p>
            </div>
          </div>
        </div>

        <!-- Verification Steps -->
        <div class="verification-steps mb-4">
          <h6 class="text-white mb-3">Complete These Steps to Continue:</h6>

          <div class="step-item d-flex align-items-center mb-3 p-3 bg-dark border border-warning rounded">
            <div class="step-icon me-3">
              <i class="fi fi-rr-id-badge text-info fs-4"></i>
            </div>
            <div class="step-content flex-grow-1">
              <h6 class="text-white mb-1">Document Verification</h6>
              <p class="text-muted mb-0 small">Upload ID card, proof of address, bank statements</p>
            </div>
            <div class="step-status">
              <?php 
                if($kyc_verified == 'verified') echo '<span class="badge bg-success">VERIFIED</span>';
                elseif($kyc_verified == '') echo '<span class="badge bg-info">PENDING</span>';
                elseif($kyc_verified == 'rejected') echo '<span class="badge bg-danger">REJECTED</span>';
              ?>
            </div>
          </div>

          <div class="step-item d-flex align-items-center mb-3 p-3 bg-dark border border-warning rounded">
            <div class="step-icon me-3">
              <i class="fi fi-rr-camera text-success fs-4"></i>
            </div>
            <div class="step-content flex-grow-1">
              <h6 class="text-white mb-1">Face Verification</h6>
              <p class="text-muted mb-0 small">Real-time selfie for identity confirmation</p>
            </div>
            <div class="step-status">
              <?php 
                if($userVerified == 0) echo '<span class="badge bg-warning">REQUIRED</span>';
                elseif($userVerified == 0 && $kycSubmitted == 1) echo '<span class="badge bg-info">PENDING</span>';
                elseif($userVerified == 1) echo '<span class="badge bg-success">VERIFIED</span>';
                elseif($kycSubmitted == 2) echo '<span class="badge bg-danger">REJECTED</span>';
              ?>
            </div>
          </div>
        </div>

        <div class="legal-notice bg-danger rounded p-3 mb-3">
          <h6 class="text-white mb-2">📋 Legal & Compliance Requirement</h6>
          <ul class="list-unstyled mb-0 small text-light">
            <li class="mb-1"><i class="fi fi-rr-scale-balanced me-2"></i>Required by Financial Intelligence Centre Act (FICA)</li>
            <li class="mb-1"><i class="fi fi-rr-shield me-2"></i>Mandatory for all financial service providers in South Africa</li>
            <li class="mb-0"><i class="fi fi-rr-lock me-2"></i>Protects against fraud and money laundering</li>
          </ul>
        </div>

      </div>

      <!-- Footer -->
      <div class="modal-footer border-top border-warning justify-content-center">
        <div class="btn-group w-100">

          <?php if ($kyc_verified != 'verified' && $kyc_verified != 'pending') { ?>
            <button onclick="window.location.href='kyc_documents.php';"
                    class="btn btn-warning btn-lg fw-bold py-3">
              <i class="fi fi-rr-upload me-2"></i>
              UPLOAD DOCUMENTS
            </button>
          <?php } ?>

          <button onclick="window.open('https://efina.co.za/face-verification/index.html', '_blank');"
                  class="btn btn-success btn-lg fw-bold py-3">
            <i class="fi fi-rr-camera me-2"></i>
            FACE VERIFICATION
          </button>

        </div>
      </div>

    </div>
  </div>
</div>

<div class="modal-backdrop fade show" style="z-index: 1040;"></div>

<style>
body {
  overflow: hidden !important;
  pointer-events: none !important;
}
#autoModal {
  pointer-events: all !important;
  z-index: 99999 !important;
}
.modal-backdrop {
  z-index: 99998 !important;
  background-color: rgba(0,0,0,0.9) !important;
}
body * {
  pointer-events: none !important;
}
#autoModal * {
  pointer-events: all !important;
}
html, body {
  height: 100%;
  margin: 0;
  padding: 0;
}
.legal-notice {
  border: 2px solid #dc3545;
}
#autoModal .modal-dialog {
  max-width: 600px;
}
.btn-lg {
  font-size: 1.1rem;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Disable all form submits & clicks outside modal
  document.querySelectorAll('form, a, button').forEach(el => {
    if (!el.closest('#autoModal')) {
      el.addEventListener('click', e => e.preventDefault());
      el.addEventListener('submit', e => e.preventDefault());
    }
  });

  // Block keyboard & right-click
  document.addEventListener('keydown', e => {
    if (['Escape', 'Tab', 'Enter'].includes(e.key)) e.preventDefault();
  });
  document.addEventListener('contextmenu', e => e.preventDefault());

  // Keep modal visible
  setInterval(() => {
    const modal = document.getElementById('autoModal');
    if (!modal.classList.contains('show')) {
      modal.classList.add('show');
      modal.style.display = 'block';
    }
  }, 1000);
});
</script>

<?php endif; ?>
<?php } ?>



