<?php session_start();

include 'includes/head.php';
include 'includes/referral_functions.php';


$referral_system = new ReferralSystem($conn);
$stats = $referral_system->getUserReferralStats($user_id);
$history = $referral_system->getReferralHistory($user_id);
$settings = $referral_system->getReferralSettings();
$referral_link = "https://E-Financeloans.co.za/register?ref=" . $stats['referral_code'];
?>
<!DOCTYPE html>
<html lang="en">

    <style>
    .referral-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
    }
    .bonus-badge {
        background: rgba(255,255,255,0.2);
        border-radius: 20px;
        padding: 8px 15px;
        margin: 5px;
    }
    .referral-link {
        background: rgba(255,255,255,0.1);
        border-radius: 10px;
        padding: 15px;
        border: 1px dashed rgba(255,255,255,0.3);
    }
    </style>
<style>
    /* Modern Card Styles */
    .referral-stats-card {
        background: linear-gradient(135deg, var(--bs-primary) 0%, var(--bs-purple) 100%);
        color: white;
        border-radius: 16px;
        border: none;
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        transition: transform 0.3s ease;
    }
    
    .referral-stats-card:hover {
        transform: translateY(-5px);
    }
    
    .referral-stats-card .card-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(255,255,255,0.2);
        margin: 0 auto 15px;
    }
    
    .referral-stats-card .card-icon i {
        font-size: 28px;
        color: white;
    }
    
    .referral-link-box {
        background: var(--bs-body-bg);
        border-radius: 12px;
        padding: 20px;
        border: 2px solid var(--bs-border-color);
        transition: all 0.3s ease;
    }
    
    .referral-link-box:focus-within {
        border-color: var(--bs-primary);
        box-shadow: 0 0 0 3px rgba(var(--bs-primary-rgb), 0.1);
    }
    
    .referral-link-input {
        background: transparent;
        border: none;
        font-family: 'Courier New', monospace;
        font-size: 14px;
        color: var(--bs-body-color);
        width: 100%;
        outline: none;
    }
    
    .share-btn {
        border-radius: 10px;
        padding: 10px 20px;
        font-weight: 500;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }
    
    .share-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .share-btn.whatsapp {
        background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
        color: white;
    }
    
    .share-btn.email {
        background: linear-gradient(135deg, #4285F4 0%, #0D47A1 100%);
        color: white;
    }
    
    .share-btn.facebook {
        background: linear-gradient(135deg, #1877F2 0%, #0D47A1 100%);
        color: white;
    }
    
    .share-btn.telegram {
        background: linear-gradient(135deg, #0088cc 0%, #005580 100%);
        color: white;
    }
    
    .bonus-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        text-align: center;
        border: 1px solid var(--bs-border-color);
        transition: all 0.3s ease;
        height: 100%;
    }
    
    .bonus-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        border-color: var(--bs-primary);
    }
    
    .bonus-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 15px;
        font-size: 24px;
    }
    
    .bonus-icon.signup {
        background: linear-gradient(135deg, #34D399 0%, #10B981 100%);
        color: white;
    }
    
    .bonus-icon.bot {
        background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
        color: white;
    }
    
    .bonus-icon.boost {
        background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
        color: white;
    }
    
    .bonus-icon.max {
        background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
        color: white;
    }
    
    .bonus-amount {
        font-size: 24px;
        font-weight: 700;
        margin: 10px 0;
        color: var(--bs-heading-color);
    }
    
    .bonus-label {
        font-size: 14px;
        color: var(--bs-secondary-color);
        margin-bottom: 5px;
    }
    
    .step-card {
        background: var(--bs-body-bg);
        border-radius: 12px;
        padding: 25px;
        border: 1px solid var(--bs-border-color);
        height: 100%;
        transition: all 0.3s ease;
    }
    
    .step-card:hover {
        border-color: var(--bs-primary);
        transform: translateY(-3px);
    }
    
    .step-number {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: var(--bs-primary);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 18px;
        margin-bottom: 20px;
    }
    
    .step-title {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 10px;
        color: var(--bs-heading-color);
    }
    
    .step-description {
        color: var(--bs-secondary-color);
        font-size: 14px;
        line-height: 1.5;
    }
    
    .history-item {
        padding: 15px;
        border-radius: 10px;
        border: 1px solid var(--bs-border-color);
        margin-bottom: 10px;
        transition: all 0.3s ease;
    }
    
    .history-item:hover {
        background: var(--bs-tertiary-bg);
        border-color: var(--bs-primary);
    }
    
    .user-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: linear-gradient(135deg, var(--bs-primary) 0%, var(--bs-purple) 100%);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 16px;
    }
    
    .withdraw-card {
        background: linear-gradient(135deg, #10B981 0%, #059669 100%);
        color: white;
        border-radius: 16px;
        border: none;
    }
    
    .progress-ring {
        width: 80px;
        height: 80px;
    }
    
    .progress-ring circle {
        fill: none;
        stroke-width: 6;
        stroke-linecap: round;
        transform: rotate(-90deg);
        transform-origin: 50% 50%;
    }
    
    .progress-ring-bg {
        stroke: rgba(255,255,255,0.2);
    }
    
    .progress-ring-progress {
        stroke: white;
        stroke-dasharray: 251.2;
        stroke-dashoffset: calc(251.2 - (251.2 * <?php echo min(100, ($stats['referral_balance'] / 500) * 100); ?>) / 100);
        transition: stroke-dashoffset 0.5s ease;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .referral-stats-card {
            margin-bottom: 20px;
        }
        
        .share-btn {
            margin-bottom: 10px;
        }
        
        .bonus-card {
            margin-bottom: 20px;
        }
    }
    
    /* Animation for copy success */
    @keyframes copySuccess {
        0% { transform: scale(1); }
        50% { transform: scale(1.1); }
        100% { transform: scale(1); }
    }
    
    .copy-success {
        animation: copySuccess 0.3s ease;
    }
    </style>
<body class="dashboard">
    <div id="main-wrapper">

        <?php include('includes/header.php');?>
        <?php include('includes/sidebar.php');?>

        <div class="content-body">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-xl-4">
                                    <div class="page-title-content">
                                        <h3>Referral Program</h3>
                                        <p class="mb-2">Earn rewards by referring friends to E-Finance Loans</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- REFERRAL STATS -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="card referral-card">
                            <div class="card-body text-center referral-card">
                                <i class="fi fi-rr-gift fs-1 mb-3"></i>
                                <h3>R <?php echo number_format($stats['referral_balance'], 2); ?></h3>
                                <p class="mb-0">Available Bonus</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card  text-white bg-success">
                            <div class="card-body text-center bg-success">
                                <i class="fi fi-rr-users fs-1 mb-3"></i>
                                <h3><?php echo $stats['total_referrals']; ?></h3>
                                <p class="mb-0">Total Referrals</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-warning text-dark">
                            <div class="card-body text-center bg-warning">
                                <i class="fi fi-rr-badge-percent fs-1 mb-3"></i>
                                <h3><?php echo $stats['referral_interest_discount']; ?>%</h3>
                                <p class="mb-0">Interest Discount</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <!-- REFERRAL LINK & SHARING -->
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Your Referral Link</h5>
                            </div>
                            <div class="card-body">
                                <div class="referral-link mb-3">
                                    <code id="referralLink">
                                        https://E-Financeloans.co.za/register?ref=<?php echo $stats['referral_code']; ?>
                                    </code>
                                </div>
                                <button class="btn btn-primary w-100 mb-2" onclick="copyReferralLink()">
                                    <i class="fi fi-rr-copy me-2"></i>Copy Referral Link
                                </button>
                                
                                <h6 class="mb-3">Share via:</h6>
                                <div class="row g-2">
                                    <div class="col-6 col-md-3">
                                        <button class="btn share-btn whatsapp w-100" onclick="shareViaWhatsApp()">
                                            <i class="fi fi-rr-phone-call me-1"></i> WhatsApp
                                        </button>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <button class="btn share-btn email w-100" onclick="shareViaEmail()">
                                            <i class="fi fi-rr-envelope me-1"></i> Email
                                        </button>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <button class="btn share-btn facebook w-100" onclick="shareViaFacebook()">
                                            <i class="fi fi-rr-thumbs-up me-1"></i> Facebook
                                        </button>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <button class="btn share-btn telegram w-100" onclick="shareViaTelegram()">
                                            <i class="fi fi-rr-paper-plane me-1"></i> Telegram
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- How It Works -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h4 class="card-title mb-0">
                                    <i class="fi fi-rr-play me-2"></i>How It Works
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-12">
                                        <div class="step-card">
                                            <div class="step-number">1</div>
                                            <div class="step-title">Share Your Link</div>
                                            <div class="step-description">
                                                Copy your unique referral link or use the share buttons to invite friends
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="step-card">
                                            <div class="step-number">2</div>
                                            <div class="step-title">Friend Signs Up</div>
                                            <div class="step-description">
                                                Your friend registers using your link and completes verification
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="step-card">
                                            <div class="step-number">3</div>
                                            <div class="step-title">Activate Trading Bot</div>
                                            <div class="step-description">
                                                Your friend subscribes to any trading bot to start automated trading
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="step-card">
                                            <div class="step-number">4</div>
                                            <div class="step-title">Earn Rewards</div>
                                            <div class="step-description">
                                                You receive instant bonuses and trading discounts for each successful referral
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                     <!-- Right Column: Rewards & History -->
                    <div class="col-lg-6">
                        <!-- Reward Structure -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title mb-0">
                                    <i class="fi fi-rr-trophy me-2"></i>Reward Structure
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <div class="bonus-card">
                                            <div class="bonus-icon signup">
                                                <i class="fi fi-rr-user-plus"></i>
                                            </div>
                                            <div class="bonus-amount">$<?php echo number_format($settings['signup_bonus_referrer'], 2); ?></div>
                                            <div class="bonus-label">Signup Bonus</div>
                                            <small class="text-muted">When friend signs up</small>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="bonus-card">
                                            <div class="bonus-icon bot">
                                                <i class="fi fi-rr-robot"></i>
                                            </div>
                                            <div class="bonus-amount">$<?php echo number_format($settings['affiliate_commission'], 2); ?></div>
                                            <div class="bonus-label">Bot Activation</div>
                                            <small class="text-muted">When friend activates bot</small>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="bonus-card">
                                            <div class="bonus-icon boost">
                                                <i class="fi fi-rr-chart-line-up"></i>
                                            </div>
                                            <div class="bonus-amount">+<?php echo $settings['discount_per_referral']; ?>%</div>
                                            <div class="bonus-label">Trading Discount</div>
                                            <small class="text-muted">Per successful referral</small>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="bonus-card">
                                            <div class="bonus-icon max">
                                                <i class="fi fi-rr-star"></i>
                                            </div>
                                            <div class="bonus-amount"><?php echo $settings['max_referral_discount']; ?>%</div>
                                            <div class="bonus-label">Maximum Discount</div>
                                            <small class="text-muted">Cumulative cap</small>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="alert alert-info mt-3">
                                    <div class="d-flex align-items-center">
                                        <i class="fi fi-rr-info text-info me-3 fs-5"></i>
                                        <div>
                                            <strong>Your friend also gets:</strong> 
                                            $<?php echo number_format($settings['signup_bonus_referred'], 2); ?> welcome bonus when they sign up with your code!
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Referral History -->
                        <div class="card mt-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">
                                    <i class="fi fi-rr-history me-2"></i>Recent Activity
                                </h4>
                                <a href="referral_history.php" class="btn btn-sm btn-outline-primary">View All</a>
                            </div>
                            <div class="card-body">
                                <?php if (!empty($history)): ?>
                                    <?php foreach ($history as $transaction): 
                                        $initial = strtoupper(substr($transaction['referred_username'], 0, 1));
                                    ?>
                                    <div class="history-item">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="d-flex align-items-center">
                                                <div class="user-avatar me-3">
                                                    <?php echo $initial; ?>
                                                </div>
                                                <div>
                                                    <h6 class="mb-1"><?php echo htmlspecialchars($transaction['referred_username']); ?></h6>
                                                    <small class="text-muted"><?php echo htmlspecialchars($transaction['description']); ?></small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <div class="fw-bold text-success">+$<?php echo number_format($transaction['amount'], 2); ?></div>
                                                <small class="text-muted"><?php echo date('M j, g:i A', strtotime($transaction['created_at'])); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="text-center py-5">
                                        <div class="mb-3">
                                            <i class="fi fi-rr-users fs-1 text-muted opacity-50"></i>
                                        </div>
                                        <h6 class="text-muted mb-2">No Referral Activity Yet</h6>
                                        <p class="text-muted mb-3">Start sharing your link to see earnings here</p>
                                        <button class="btn btn-primary" onclick="document.getElementById('referralLink').focus()">
                                            <i class="fi fi-rr-link me-2"></i>Copy Your Link
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Withdrawal Section -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card withdraw-card">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <div class="d-flex align-items-center">
                                            <div class="me-4">
                                                <svg class="progress-ring" viewBox="0 0 100 100">
                                                    <circle class="progress-ring-bg" cx="50" cy="50" r="40"></circle>
                                                    <circle class="progress-ring-progress" cx="50" cy="50" r="40"></circle>
                                                </svg>
                                            </div>
                                            <div>
                                                <h4 class="text-white mb-2">Withdraw Your Earnings</h4>
                                                <p class="text-white opacity-75 mb-0">
                                                    Current balance: <strong>$<?php echo number_format($stats['referral_balance'], 2); ?></strong>
                                                    • Minimum withdrawal: $500.00
                                                </p>
                                                <div class="progress mt-3" style="height: 8px; background: rgba(255,255,255,0.2);">
                                                    <div class="progress-bar bg-white" 
                                                         style="width: <?php echo min(100, ($stats['referral_balance'] / 500) * 100); ?>%;">
                                                    </div>
                                                </div>
                                                <small class="text-white opacity-75 mt-2 d-block">
                                                    <?php 
                                                    if ($stats['referral_balance'] >= 500) {
                                                        echo "Ready to withdraw!";
                                                    } else {
                                                        $needed = 500 - $stats['referral_balance'];
                                                        echo "$" . number_format($needed, 2) . " more to reach minimum";
                                                    }
                                                    ?>
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 text-end">
                                        <button class="btn btn-light btn-lg px-4 py-3 fw-bold" 
                                                id="withdrawBtn"
                                                <?php echo $stats['referral_balance'] < 500 ? 'disabled' : ''; ?>
                                                onclick="requestWithdrawal()">
                                            <i class="fi fi-rr-bank me-2"></i>
                                            <?php echo $stats['referral_balance'] >= 500 ? 'Withdraw Now' : 'Not Available'; ?>
                                        </button>
                                        <?php if ($stats['referral_balance'] < 500): ?>
                                        <small class="text-white opacity-75 mt-2 d-block">
                                            Min $500 required
                                        </small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php include('includes/footer.php');?>
        
    </div>

    <script>
    function copyReferralLink() {
        const link = document.getElementById('referralLink');
        const textArea = document.createElement('textarea');
        textArea.value = link.textContent;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        
        alert('Referral link copied to clipboard!');
    }

    function shareViaWhatsApp() {
        const link = document.getElementById('referralLink').textContent;
        const message = `Join E-Finance Loans using my referral link and we both get cash bonuses! ${link}`;
        const url = `https://wa.me/?text=${encodeURIComponent(message)}`;
        window.open(url, '_blank');
    }

    function shareViaEmail() {
        const link = document.getElementById('referralLink').textContent;
        const subject = 'Join E-Finance Loans - Get R50 Welcome Bonus!';
        const body = `Hi! I'm using E-Finance Loans and thought you might be interested. Use my referral link to sign up and we both get cash bonuses:\n\n${link}\n\nBest regards`;
        const url = `mailto:?subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(body)}`;
        window.location.href = url;
    }

    function requestWithdrawal() {
        if (confirm('Request withdrawal of your referral earnings? This will be processed within 3-5 business days.')) {
            // AJAX call to process withdrawal
            alert('Withdrawal request submitted! We will process it within 3-5 business days.');
        }
    }
    </script>
</body>
</html>