<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resend Verification Email</title>
    <style>
        .verification-container {
            max-width: 500px;
            margin: 100px auto;
            padding: 40px;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            text-align: center;
        }
        .email-icon {
            font-size: 80px;
            color: #007bff;
            margin-bottom: 20px;
        }
        .btn-primary {
            background: #007bff;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            color: white;
            text-decoration: none;
            display: inline-block;
        }
        .btn-primary:hover {
            background: #0056b3;
            color: white;
        }
        .btn-outline-secondary {
            border: 2px solid #6c757d;
            color: #6c757d;
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
        }
        .btn-outline-secondary:hover {
            background: #6c757d;
            color: white;
        }
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 16px;
        }
        .form-control:focus {
            border-color: #007bff;
            outline: none;
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .d-grid {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .text-primary {
            color: #007bff;
        }
        .text-muted {
            color: #6c757d;
        }
        .fw-bold {
            font-weight: bold;
        }
        .mb-3 {
            margin-bottom: 1rem;
        }
        .mb-4 {
            margin-bottom: 1.5rem;
        }
    </style>
</head>
<body style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px 0; display: flex; align-items: center;">

<div class="verification-container">
    <?php
    include 'includes/config.php';
    
    
    $message = '';
    $message_type = '';
    $email = isset($_GET['email']) ? $_GET['email'] : '';
    $email_input = isset($_POST['email']) ? $_POST['email'] : $email;
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $email = trim($_POST['email']);
        
        if (empty($email)) {
            $message = 'Please enter your email address.';
            $message_type = 'danger';
        } else {
            // Check if user exists and email is not verified
            $sql = "SELECT id, first_name, verification_token FROM users WHERE email = '$email' AND email_verified = '0'";
            $result = mysqli_query($conn, $sql);
            
            if (mysqli_num_rows($result) > 0) {
                $user = mysqli_fetch_assoc($result);
                $user_id = $user['id'];
                $first_name = $user['first_name'];
                
                // Generate new verification token
                $new_token = $new_token;
                $token_expires = date('Y-m-d H:i:s', strtotime('+1 hour'));
                
                // Update user with new token
                $update_sql = "UPDATE users SET verification_token = '$new_token', verification_token_expires = '$token_expires' WHERE id = '$user_id'";
                
                if (mysqli_query($conn, $update_sql)) {
                    // Send verification email
                    $verificationLink = "https://yourdomain.com/register/verify-email.php?token=" . $new_token;
                    
                     // Your email configuration

                    $mail_message = "<!-- Content Section -->
                            <div class='email-content'>
                                <h2 class='greeting'>Hello <span class='user-name'>".$rName."</span>,</h2>
                                
                                <p class='message'>
                                    Thank you for choosing <strong>".$sitename."</strong>. To activate your account and access all features, 
                                    please verify your email address by clicking the button below.
                                </p>

                                <!-- Verification Section -->
                                <div class='verification-section'>
                                    <div style='text-align: center;'>
                                        <a href='".$verificationLink."' class='verification-button'>
                                            Verify Email Address
                                        </a>
                                    </div>
                                </div>

                                <!-- Alternative Link -->
                                <div class='link-alternative'>
                                    <p style='margin-bottom: 10px; color: #6c757d; font-size: 13px;'>Or copy and paste this link in your browser:</p>
                                    <a href='".$verificationLink."' class='verification-link'>".$verificationLink."</a>
                                </div>

                                <!-- Security Notice -->
                                <div class='security-notice'>
                                    <div class='security-title'>🔒 Security Notice</div>
                                    <div class='security-text'>
                                        For your security, please verify your email within the next hour. 
                                        This ensures your account remains secure and active.
                                    </div>
                                </div>

                                <!-- Expiry Notice -->
                                <div class='expiry-notice'>
                                    <div class='expiry-text'>⏰ This verification link expires in 1 hour</div>
                                </div>

                                <!-- Support Section -->
                                <div class='support-section'>
                                    <p class='support-text'>Need assistance with your account?</p>
                                    <a href='".$myUrl."/contact.php' class='support-link'>Contact Our Support Team</a>
                                </div>

                                <p class='message' style='margin-bottom: 0; color: #6c757d; font-size: 14px;'>
                                    If you didn't create an account with ".$sitename.", please ignore this email. 
                                    Your account will not be activated until you complete the verification process.
                                </p>
                            </div>"; 

                    include("proccess/mail_sender.php");


                } else {
                    $message = 'Database error. Please try again.';
                    $message_type = 'danger';
                }
            } else {
                $message = 'No unverified account found with this email address.';
                $message_type = 'danger';
            }
        }
    }
    ?>
    
    <div class="email-icon">
        <i class="fas fa-envelope"></i>
    </div>
    
    <h2 class="text-primary fw-bold mb-3">Resend Verification Email</h2>
    
    <p class="text-muted mb-4">
        Enter your email address to receive a new verification link.
    </p>
    
    <?php if (!empty($message)): ?>
        <div class="alert alert-<?php echo $message_type; ?>">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>
    
    <form method="POST" action="">
        <input type="email" 
               name="email" 
               class="form-control" 
               placeholder="Enter your email address" 
               value="<?php echo htmlspecialchars($email_input); ?>" 
               required>
        
        <div class="d-grid gap-2">
            <button type="submit" class="btn btn-primary">Send Verification Email</button>
            <a href="login.php" class="btn btn-outline-secondary">Back to Login</a>
            <a href="index.php" class="btn btn-link">Register New Account</a>
        </div>
    </form>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

</body>
</html>