<?php
session_start();
include 'includes/head.php';

// Get user's current bot subscription for API access
$api_access = false;
$current_plan = "None";

$subscription_sql = "SELECT tbp.plan_name, tbp.has_api_access 
                     FROM user_bot_subscriptions ubs
                     JOIN trading_bot_plans tbp ON ubs.bot_plan_id = tbp.id
                     WHERE ubs.user_id = '$user_id' AND ubs.status = 'active' 
                     LIMIT 1";
$subscription_result = mysqli_query($conn, $subscription_sql);
if ($subscription_result && mysqli_num_rows($subscription_result) > 0) {
    $subscription = mysqli_fetch_assoc($subscription_result);
    $current_plan = $subscription['plan_name'];
    $api_access = $subscription['has_api_access'] == 1;
}

// Get user security settings
$security_sql = "SELECT * FROM user_security WHERE user_id = '$user_id' LIMIT 1";
$security_result = mysqli_query($conn, $security_sql);
$security = $security_result && mysqli_num_rows($security_result) > 0 
    ? mysqli_fetch_assoc($security_result) 
    : ['two_factor_enabled' => 0, 'withdrawal_pin' => null, 'email_notifications' => 1];

// Get secondary emails
$secondary_emails = [];
$emails_sql = "SELECT * FROM user_secondary_emails WHERE user_id = '$user_id' AND verified = 1";
$emails_result = mysqli_query($conn, $emails_sql);
while ($row = mysqli_fetch_assoc($emails_result)) {
    $secondary_emails[] = $row;
}

// Get active devices
$devices = [];
$devices_sql = "SELECT * FROM user_devices WHERE user_id = '$user_id' ORDER BY last_login DESC LIMIT 10";
$devices_result = mysqli_query($conn, $devices_sql);
while ($row = mysqli_fetch_assoc($devices_result)) {
    $devices[] = $row;
}

// Get login activity
$logins = [];
$logins_sql = "SELECT * FROM user_login_history WHERE user_id = '$user_id' ORDER BY login_time DESC LIMIT 20";
$logins_result = mysqli_query($conn, $logins_sql);
while ($row = mysqli_fetch_assoc($logins_result)) {
    $logins[] = $row;
}

// Get API keys if user has access
$api_keys = [];
if ($api_access) {
    $api_sql = "SELECT * FROM user_api_keys WHERE user_id = '$user_id' AND status = 'active'";
    $api_result = mysqli_query($conn, $api_sql);
    while ($row = mysqli_fetch_assoc($api_result)) {
        // Mask the API key for display
        $row['masked_key'] = substr($row['api_key'], 0, 8) . '...' . substr($row['api_key'], -8);
        $api_keys[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="<?php echo isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light'; ?>">
<head>
    
    <style>
        .settings-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .settings-section {
            margin-bottom: 30px;
        }
        .settings-section-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--bs-heading-color);
            padding-bottom: 10px;
            border-bottom: 2px solid var(--bs-border-color);
        }
        .feature-badge {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        .api-key-display {
            background: var(--bs-tertiary-bg);
            border-radius: 8px;
            padding: 15px;
            font-family: monospace;
            word-break: break-all;
            position: relative;
        }
        .copy-btn {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        .device-card {
            border: 1px solid var(--bs-border-color);
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 10px;
            transition: all 0.3s ease;
        }
        .device-card:hover {
            border-color: var(--bs-primary);
            background: var(--bs-tertiary-bg);
        }
        .device-current {
            border-left: 4px solid var(--bs-success);
        }
        .login-success {
            color: var(--bs-success);
        }
        .login-failed {
            color: var(--bs-danger);
        }
        .security-status {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 600;
        }
        .security-enabled {
            background: var(--bs-success-bg-subtle);
            color: var(--bs-success);
        }
        .security-disabled {
            background: var(--bs-danger-bg-subtle);
            color: var(--bs-danger);
        }
        .qr-code-container {
            text-align: center;
            padding: 20px;
            background: white;
            border-radius: 8px;
            border: 1px solid var(--bs-border-color);
        }
        .backup-codes {
            background: var(--bs-warning-bg-subtle);
            border: 1px solid var(--bs-warning-border-subtle);
            border-radius: 8px;
            padding: 15px;
            margin-top: 15px;
        }
        .backup-code {
            font-family: monospace;
            font-size: 1.1rem;
            font-weight: 600;
            text-align: center;
            padding: 8px;
            margin: 5px;
            background: white;
            border-radius: 4px;
            border: 1px dashed var(--bs-border-color);
        }
    </style>
</head>
<body class="dashboard">
    <div id="main-wrapper">
        <?php include('includes/header.php');?>
        <?php include('includes/sidebar.php');?>

        <div class="content-body">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-xl-4">
                                    <div class="page-title-content">
                                        <h3>Account Settings</h3>
                                        <p class="mb-2">Manage your account security and preferences</p>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="breadcrumbs">
                                        <a href="dashboard.php">Home</a>
                                        <span><i class="fi fi-rr-angle-small-right"></i></span>
                                        <a href="#">Settings</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Security Overview -->
                <div class="row">
                    <div class="col-12">
                        <div class="card settings-card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3 text-center mb-3 mb-md-0">
                                        <div class="mb-2">
                                            <i class="fi fi-rr-shield-check fs-1 text-primary"></i>
                                        </div>
                                        <h5>Security Score</h5>
                                        <div class="display-4 fw-bold text-success">
                                            <?php
                                            $score = 40; // Base score
                                            if ($security['two_factor_enabled']) $score += 30;
                                            if ($security['withdrawal_pin']) $score += 20;
                                            if (count($secondary_emails) > 0) $score += 10;
                                            echo $score;
                                            ?>%
                                        </div>
                                        <small class="text-muted">of 100%</small>
                                    </div>
                                    <div class="col-md-9">
                                        <h5 class="mb-3">Security Status</h5>
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <?php if ($security['two_factor_enabled']): ?>
                                                            <i class="fi fi-rr-check-circle text-success fs-4"></i>
                                                        <?php else: ?>
                                                            <i class="fi fi-rr-times-circle text-danger fs-4"></i>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-0">2FA Authentication</h6>
                                                        <small class="text-muted">
                                                            <?php echo $security['two_factor_enabled'] ? 'Enabled' : 'Not Enabled'; ?>
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <?php if ($security['withdrawal_pin']): ?>
                                                            <i class="fi fi-rr-check-circle text-success fs-4"></i>
                                                        <?php else: ?>
                                                            <i class="fi fi-rr-times-circle text-danger fs-4"></i>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-0">Withdrawal PIN</h6>
                                                        <small class="text-muted">
                                                            <?php echo $security['withdrawal_pin'] ? 'Set' : 'Not Set'; ?>
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-3">
                                                        <i class="fi fi-rr-check-circle <?php echo count($secondary_emails) > 0 ? 'text-success' : 'text-warning'; ?> fs-4"></i>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-0">Recovery Emails</h6>
                                                        <small class="text-muted">
                                                            <?php echo count($secondary_emails) . ' verified'; ?>
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="progress mb-3" style="height: 8px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo $score; ?>%;"></div>
                                        </div>
                                        <small class="text-muted">
                                            <?php if ($score < 70): ?>
                                                <i class="fi fi-rr-exclamation-triangle text-warning me-1"></i>
                                                Your security needs improvement. Enable 2FA for better protection.
                                            <?php else: ?>
                                                <i class="fi fi-rr-check-circle text-success me-1"></i>
                                                Good security level. Keep your devices updated.
                                            <?php endif; ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Left Column: Security & API -->
                    <div class="col-xl-8">
                        <!-- API Settings -->
                        <div class="settings-section">
                            <h4 class="settings-section-title">
                                <i class="fi fi-rr-code me-2"></i>API Access
                                <?php if (!$api_access): ?>
                                    <span class="badge bg-warning feature-badge">Premium Feature</span>
                                <?php endif; ?>
                            </h4>
                            
                            <div class="card settings-card">
                                <div class="card-body">
                                    <div class="mb-4">
                                        <h5>API Status</h5>
                                        <p class="text-muted">
                                            <?php if ($api_access): ?>
                                                <span class="security-status security-enabled">
                                                    <i class="fi fi-rr-check me-1"></i>API Access Enabled
                                                </span>
                                                <span class="ms-3">
                                                    Current Plan: <strong><?php echo htmlspecialchars($current_plan); ?></strong>
                                                </span>
                                            <?php else: ?>
                                                <span class="security-status security-disabled">
                                                    <i class="fi fi-rr-times me-1"></i>API Access Not Available
                                                </span>
                                                <span class="ms-3 text-muted">
                                                    Upgrade to <strong>AI Quantum</strong> or higher for API access
                                                </span>
                                            <?php endif; ?>
                                        </p>
                                    </div>

                                    <?php if ($api_access): ?>
                                        <!-- Generate New API Key -->
                                        <div class="mb-4">
                                            <h6>Generate New API Key</h6>
                                            <form id="generateApiForm">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="form-label">Key Name</label>
                                                        <input type="text" class="form-control" name="key_name" placeholder="e.g., Trading Bot #1" required>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="form-label">Permissions</label>
                                                        <select class="form-select" name="permissions" required>
                                                            <option value="read">Read Only</option>
                                                            <option value="trade">Trading Access</option>
                                                            <option value="full">Full Access</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">IP Restrictions (Optional)</label>
                                                    <input type="text" class="form-control" name="ip_restrictions" placeholder="192.168.1.1, 10.0.0.1">
                                                    <small class="text-muted">Comma-separated list of allowed IPs. Leave empty for no restrictions.</small>
                                                </div>
                                                <div class="mb-3 form-check">
                                                    <input type="checkbox" class="form-check-input" id="agreeTerms" required>
                                                    <label class="form-check-label" for="agreeTerms">
                                                        I understand that API keys provide access to my account. Keep them secure.
                                                    </label>
                                                </div>
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fi fi-rr-key me-1"></i>Generate API Key
                                                </button>
                                            </form>
                                        </div>

                                        <!-- Active API Keys -->
                                        <?php if (!empty($api_keys)): ?>
                                        <div class="mb-4">
                                            <h6>Active API Keys</h6>
                                            <?php foreach($api_keys as $api_key): ?>
                                            <div class="api-key-display mb-3">
                                                <button class="btn btn-sm btn-outline-secondary copy-btn" 
                                                        data-key="<?php echo htmlspecialchars($api_key['api_key']); ?>">
                                                    <i class="fi fi-rr-copy"></i>
                                                </button>
                                                <div class="mb-2">
                                                    <strong><?php echo htmlspecialchars($api_key['key_name']); ?></strong>
                                                    <span class="badge bg-secondary ms-2"><?php echo ucfirst($api_key['permissions']); ?></span>
                                                    <span class="badge bg-<?php echo $api_key['status'] == 'active' ? 'success' : 'secondary'; ?> ms-1">
                                                        <?php echo ucfirst($api_key['status']); ?>
                                                    </span>
                                                </div>
                                                <div class="mb-2">
                                                    <small class="text-muted">Key: <?php echo htmlspecialchars($api_key['masked_key']); ?></small>
                                                </div>
                                                <div class="d-flex justify-content-between">
                                                    <small class="text-muted">
                                                        Created: <?php echo date('M j, Y', strtotime($api_key['created_at'])); ?>
                                                    </small>
                                                    <small>
                                                        <a href="#" class="text-danger revoke-api" data-id="<?php echo $api_key['id']; ?>">
                                                            <i class="fi fi-rr-trash me-1"></i>Revoke
                                                        </a>
                                                    </small>
                                                </div>
                                            </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <?php endif; ?>

                                        <!-- API Documentation -->
                                        <div class="alert alert-info">
                                            <h6><i class="fi fi-rr-document me-2"></i>API Documentation</h6>
                                            <p class="mb-2">Access our API documentation for integration guides and examples:</p>
                                            <a href="api-documentation.php" class="btn btn-sm btn-outline-info">
                                                <i class="fi fi-rr-book-open me-1"></i>View Documentation
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <!-- Upgrade Prompt -->
                                        <div class="alert alert-warning">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0 me-3">
                                                    <i class="fi fi-rr-lock fs-1"></i>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h5 class="alert-heading">API Access Requires Upgrade</h5>
                                                    <p class="mb-2">API integration is available only for <strong>AI Quantum</strong> and <strong>AI Omega</strong> plans.</p>
                                                    <a href="trading-bots.php" class="btn btn-warning">
                                                        <i class="fi fi-rr-arrow-up me-1"></i>Upgrade Your Plan
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- 2FA Settings -->
                        <div class="settings-section">
                            <h4 class="settings-section-title">
                                <i class="fi fi-rr-shield-check me-2"></i>Two-Factor Authentication
                            </h4>
                            
                            <div class="card settings-card">
                                <div class="card-body">
                                    <div class="mb-4">
                                        <h5>2FA Status</h5>
                                        <p class="text-muted">
                                            <?php if ($security['two_factor_enabled']): ?>
                                                <span class="security-status security-enabled">
                                                    <i class="fi fi-rr-check me-1"></i>2FA Enabled
                                                </span>
                                            <?php else: ?>
                                                <span class="security-status security-disabled">
                                                    <i class="fi fi-rr-times me-1"></i>2FA Disabled
                                                </span>
                                            <?php endif; ?>
                                        </p>
                                    </div>

                                    <?php if (!$security['two_factor_enabled']): ?>
                                        <!-- Enable 2FA -->
                                        <div id="enable2faSection">
                                            <h6>Enable Two-Factor Authentication</h6>
                                            <p class="text-muted mb-3">Add an extra layer of security to your account using Google Authenticator.</p>
                                            <button class="btn btn-primary" onclick="enable2FA()">
                                                <i class="fi fi-rr-shield-plus me-1"></i>Enable 2FA
                                            </button>
                                        </div>
                                    <?php else: ?>
                                        <!-- Manage 2FA -->
                                        <div class="row">
                                            <div class="col-md-6 mb-4">
                                                <h6>Backup Codes</h6>
                                                <p class="text-muted mb-3">Save these codes in a secure place. Each code can be used once.</p>
                                                <button class="btn btn-outline-warning mb-3" onclick="generateBackupCodes()">
                                                    <i class="fi fi-rr-refresh me-1"></i>Generate New Backup Codes
                                                </button>
                                                
                                                <!-- Backup Codes Display (Hidden by default) -->
                                                <div id="backupCodesDisplay" style="display: none;">
                                                    <div class="backup-codes">
                                                        <div class="row row-cols-2 g-2" id="backupCodesList">
                                                            <!-- Backup codes will be loaded here -->
                                                        </div>
                                                        <div class="mt-3">
                                                            <button class="btn btn-sm btn-outline-secondary" onclick="printBackupCodes()">
                                                                <i class="fi fi-rr-print me-1"></i>Print Codes
                                                            </button>
                                                            <button class="btn btn-sm btn-outline-success" onclick="downloadBackupCodes()">
                                                                <i class="fi fi-rr-download me-1"></i>Download
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-4">
                                                <h6>2FA Settings</h6>
                                                <div class="mb-3">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" type="checkbox" id="require2faLogin" 
                                                               <?php echo $security['two_factor_enabled'] ? 'checked' : ''; ?>>
                                                        <label class="form-check-label" for="require2faLogin">
                                                            Require 2FA on every login
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" type="checkbox" id="require2faWithdrawal" 
                                                               <?php echo $security['require_2fa_withdrawal'] ?: 0 ? 'checked' : ''; ?>>
                                                        <label class="form-check-label" for="require2faWithdrawal">
                                                            Require 2FA for withdrawals
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Disable 2FA -->
                                        <div class="alert alert-warning mt-3">
                                            <h6><i class="fi fi-rr-exclamation-triangle me-2"></i>Disable 2FA</h6>
                                            <p class="mb-2">Disabling 2FA will reduce your account security.</p>
                                            <button class="btn btn-outline-danger" onclick="disable2FA()">
                                                <i class="fi fi-rr-shield-minus me-1"></i>Disable 2FA
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Email & Notification Settings -->
                        <div class="settings-section">
                            <h4 class="settings-section-title">
                                <i class="fi fi-rr-envelope me-2"></i>Email & Notifications
                            </h4>
                            
                            <div class="card settings-card">
                                <div class="card-body">
                                    <!-- Primary Email -->
                                    <div class="mb-4">
                                        <h6>Primary Email</h6>
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div>
                                                <strong><?php echo htmlspecialchars($userEmail); ?></strong>
                                                <span class="badge bg-success ms-2">Verified</span>
                                            </div>
                                            <button class="btn btn-outline-primary btn-sm" onclick="changePrimaryEmail()">
                                                <i class="fi fi-rr-edit me-1"></i>Change
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Secondary Emails -->
                                    <div class="mb-4">
                                        <h6>Secondary Emails</h6>
                                        <p class="text-muted mb-3">Add backup email addresses for account recovery.</p>
                                        
                                        <?php if (!empty($secondary_emails)): ?>
                                            <?php foreach($secondary_emails as $email): ?>
                                            <div class="d-flex align-items-center justify-content-between mb-2">
                                                <div>
                                                    <span><?php echo htmlspecialchars($email['email']); ?></span>
                                                    <span class="badge bg-<?php echo $email['verified'] ? 'success' : 'warning'; ?> ms-2">
                                                        <?php echo $email['verified'] ? 'Verified' : 'Pending'; ?>
                                                    </span>
                                                </div>
                                                <button class="btn btn-outline-danger btn-sm remove-email" data-id="<?php echo $email['id']; ?>">
                                                    <i class="fi fi-rr-trash"></i>
                                                </button>
                                            </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                        
                                        <!-- Add Secondary Email -->
                                        <form id="addSecondaryEmailForm" class="mt-3">
                                            <div class="input-group">
                                                <input type="email" class="form-control" name="email" placeholder="Add new email address" required>
                                                <button class="btn btn-primary" type="submit">
                                                    <i class="fi fi-rr-plus"></i> Add
                                                </button>
                                            </div>
                                        </form>
                                    </div>

                                    <!-- Notification Preferences -->
                                    <div class="mb-4">
                                        <h6>Email Notifications</h6>
                                        <div class="mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="notifyLogin" 
                                                       <?php echo $security['notify_login'] ?: 1 ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="notifyLogin">
                                                    New login alerts
                                                </label>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="notifyWithdrawal" 
                                                       <?php echo $security['notify_withdrawal'] ?: 1 ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="notifyWithdrawal">
                                                    Withdrawal requests
                                                </label>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="notifyDeposit" 
                                                       <?php echo $security['notify_deposit'] ?: 1 ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="notifyDeposit">
                                                    Deposit confirmations
                                                </label>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="notifyTrade" 
                                                       <?php echo $security['notify_trade'] ?: 1 ? 'checked' : ''; ?>>
                                                <label class="form-check-label" for="notifyTrade">
                                                    Trading activity
                                                </label>
                                            </div>
                                        </div>
                                        <button class="btn btn-primary" onclick="saveNotificationSettings()">
                                            <i class="fi fi-rr-check me-1"></i>Save Preferences
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column: Security & Activity -->
                    <div class="col-xl-4">
                        <!-- Withdrawal PIN -->
                        <div class="settings-section">
                            <h4 class="settings-section-title">
                                <i class="fi fi-rr-lock me-2"></i>Withdrawal PIN
                            </h4>
                            
                            <div class="card settings-card">
                                <div class="card-body">
                                    <div class="mb-4">
                                        <h6>PIN Status</h6>
                                        <p class="text-muted">
                                            <?php if ($security['withdrawal_pin']): ?>
                                                <span class="security-status security-enabled">
                                                    <i class="fi fi-rr-check me-1"></i>PIN Set
                                                </span>
                                            <?php else: ?>
                                                <span class="security-status security-disabled">
                                                    <i class="fi fi-rr-times me-1"></i>No PIN Set
                                                </span>
                                            <?php endif; ?>
                                        </p>
                                    </div>

                                    <?php if (!$security['withdrawal_pin']): ?>
                                        <!-- Set Withdrawal PIN -->
                                        <div id="setPinSection">
                                            <h6>Set Withdrawal PIN</h6>
                                            <p class="text-muted mb-3">Create a 6-digit PIN for withdrawal authorization.</p>
                                            <form id="setPinForm">
                                                <div class="mb-3">
                                                    <label class="form-label">New PIN (6 digits)</label>
                                                    <input type="password" class="form-control" name="pin" 
                                                           maxlength="6" pattern="[0-9]{6}" placeholder="000000" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Confirm PIN</label>
                                                    <input type="password" class="form-control" name="confirm_pin" 
                                                           maxlength="6" pattern="[0-9]{6}" placeholder="000000" required>
                                                </div>
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fi fi-rr-lock me-1"></i>Set PIN
                                                </button>
                                            </form>
                                        </div>
                                    <?php else: ?>
                                        <!-- Change Withdrawal PIN -->
                                        <div id="changePinSection">
                                            <h6>Change Withdrawal PIN</h6>
                                            <form id="changePinForm">
                                                <div class="mb-3">
                                                    <label class="form-label">Current PIN</label>
                                                    <input type="password" class="form-control" name="current_pin" 
                                                           maxlength="6" pattern="[0-9]{6}" placeholder="000000" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">New PIN (6 digits)</label>
                                                    <input type="password" class="form-control" name="new_pin" 
                                                           maxlength="6" pattern="[0-9]{6}" placeholder="000000" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Confirm New PIN</label>
                                                    <input type="password" class="form-control" name="confirm_new_pin" 
                                                           maxlength="6" pattern="[0-9]{6}" placeholder="000000" required>
                                                </div>
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fi fi-rr-refresh me-1"></i>Change PIN
                                                </button>
                                            </form>
                                            
                                            <!-- Forgot PIN -->
                                            <div class="mt-3">
                                                <a href="#" class="text-danger" onclick="resetPin()">
                                                    <i class="fi fi-rr-question-circle me-1"></i>Forgot PIN?
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Active Devices -->
                        <div class="settings-section">
                            <h4 class="settings-section-title">
                                <i class="fi fi-rr-laptop me-2"></i>Active Devices
                            </h4>
                            
                            <div class="card settings-card">
                                <div class="card-body">
                                    <h6>Currently Active</h6>
                                    <?php if (!empty($devices)): ?>
                                        <?php foreach($devices as $device): 
                                            $isCurrent = $device['session_id'] === session_id();
                                        ?>
                                        <div class="device-card <?php echo $isCurrent ? 'device-current' : ''; ?>">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div>
                                                    <h6 class="mb-1"><?php echo htmlspecialchars($device['device_name']); ?></h6>
                                                    <small class="text-muted">
                                                        <?php echo htmlspecialchars($device['browser']); ?> • 
                                                        <?php echo htmlspecialchars($device['platform']); ?>
                                                    </small>
                                                </div>
                                                <?php if (!$isCurrent): ?>
                                                    <button class="btn btn-outline-danger btn-sm remove-device" 
                                                            data-id="<?php echo $device['id']; ?>">
                                                        <i class="fi fi-rr-sign-out"></i>
                                                    </button>
                                                <?php else: ?>
                                                    <span class="badge bg-success">Current</span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="mt-2">
                                                <small class="text-muted">
                                                    <i class="fi fi-rr-clock me-1"></i>
                                                    Last active: <?php echo date('M j, g:i A', strtotime($device['last_login'])); ?>
                                                </small>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <p class="text-muted">No active devices found.</p>
                                    <?php endif; ?>
                                    
                                    <div class="mt-3">
                                        <button class="btn btn-outline-danger btn-sm" onclick="logoutAllDevices()">
                                            <i class="fi fi-rr-power me-1"></i>Logout All Devices
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Login Activity -->
                        <div class="settings-section">
                            <h4 class="settings-section-title">
                                <i class="fi fi-rr-history me-2"></i>Recent Login Activity
                            </h4>
                            
                            <div class="card settings-card">
                                <div class="card-body">
                                    <?php if (!empty($logins)): ?>
                                        <div class="login-activity">
                                            <?php foreach($logins as $login): ?>
                                            <div class="mb-3 pb-2 border-bottom">
                                                <div class="d-flex justify-content-between">
                                                    <div>
                                                        <strong><?php echo htmlspecialchars($login['location']); ?></strong>
                                                        <br>
                                                        <small class="text-muted">
                                                            <?php echo htmlspecialchars($login['browser']); ?> • 
                                                            <?php echo htmlspecialchars($login['platform']); ?>
                                                        </small>
                                                    </div>
                                                    <div class="text-end">
                                                        <span class="<?php echo $login['success'] ? 'login-success' : 'login-failed'; ?>">
                                                            <?php echo $login['success'] ? 'Success' : 'Failed'; ?>
                                                        </span>
                                                        <br>
                                                        <small class="text-muted">
                                                            <?php echo date('M j, g:i A', strtotime($login['login_time'])); ?>
                                                        </small>
                                                    </div>
                                                </div>
                                                <small class="text-muted">
                                                    IP: <?php echo htmlspecialchars($login['ip_address']); ?>
                                                </small>
                                            </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <div class="text-center mt-3">
                                            <a href="login-history.php" class="btn btn-outline-primary btn-sm">
                                                <i class="fi fi-rr-list me-1"></i>View Full History
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <p class="text-muted">No login history available.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Account Actions -->
                        <div class="settings-section">
                            <h4 class="settings-section-title">
                                <i class="fi fi-rr-settings me-2"></i>Account Actions
                            </h4>
                            
                            <div class="card settings-card">
                                <div class="card-body">
                                    <div class="d-grid gap-2">
                                        <button class="btn btn-outline-secondary" onclick="exportData()">
                                            <i class="fi fi-rr-download me-1"></i>Export Account Data
                                        </button>
                                        <button class="btn btn-outline-warning" onclick="changePassword()">
                                            <i class="fi fi-rr-key me-1"></i>Change Password
                                        </button>
                                        <button class="btn btn-outline-danger" onclick="deleteAccount()">
                                            <i class="fi fi-rr-trash me-1"></i>Delete Account
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('includes/footer.php');?>
    </div>

    <!-- 2FA QR Code Modal -->
    <div class="modal fade" id="qrCodeModal" tabindex="-1">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Setup Two-Factor Authentication</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="qr-code-container mb-3">
                        <img id="qrCodeImage" src="" alt="QR Code" style="width: 200px; height: 200px;">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Manual Setup Code</label>
                        <input type="text" class="form-control" id="setupCode" readonly>
                        <button class="btn btn-sm btn-outline-secondary mt-2" onclick="copySetupCode()">
                            <i class="fi fi-rr-copy me-1"></i>Copy Code
                        </button>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Enter 6-digit Code</label>
                        <input type="text" class="form-control" id="verificationCode" 
                               maxlength="6" pattern="[0-9]{6}" placeholder="000000">
                        <small class="text-muted">Enter the code from your authenticator app</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="verify2faBtn" onclick="verify2FA()">
                        Verify & Enable
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Change Email Modal -->
    <div class="modal fade" id="changeEmailModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Change Primary Email</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="changeEmailForm">
                        <div class="mb-3">
                            <label class="form-label">Current Password</label>
                            <input type="password" class="form-control" name="current_password" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">New Email Address</label>
                            <input type="email" class="form-control" name="new_email" required>
                        </div>
                        <div class="alert alert-warning">
                            <small>
                                <i class="fi fi-rr-exclamation-triangle me-1"></i>
                                A verification email will be sent to the new address. 
                                Your account will be locked until verification is complete.
                            </small>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="submitEmailChange()">
                        Change Email
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
    // API Functions
    $(document).ready(function() {
        // Generate API Key
        $('#generateApiForm').on('submit', function(e) {
            e.preventDefault();
            
            $.ajax({
                url: 'api/generate_key.php',
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    try {
                        const result = JSON.parse(response);
                        if (result.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'API Key Generated',
                                html: `<p>Your new API key has been generated:</p>
                                       <div class="alert alert-info">
                                           <strong>${result.api_key}</strong>
                                       </div>
                                       <p class="text-danger"><small>Save this key now! It won't be shown again.</small></p>`,
                                showCancelButton: true,
                                confirmButtonText: 'Copy Key',
                                cancelButtonText: 'Close'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    navigator.clipboard.writeText(result.api_key);
                                    Swal.fire('Copied!', 'API key copied to clipboard', 'success');
                                }
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error', result.message, 'error');
                        }
                    } catch (e) {
                        Swal.fire('Error', 'Server error. Please try again.', 'error');
                    }
                }
            });
        });

        // Copy API Key
        $('.copy-btn').on('click', function() {
            const key = $(this).data('key');
            navigator.clipboard.writeText(key);
            $(this).html('<i class="fi fi-rr-check"></i>');
            setTimeout(() => {
                $(this).html('<i class="fi fi-rr-copy"></i>');
            }, 2000);
        });

        // Revoke API Key
        $('.revoke-api').on('click', function(e) {
            e.preventDefault();
            const keyId = $(this).data('id');
            
            Swal.fire({
                title: 'Revoke API Key?',
                text: 'This action cannot be undone.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Revoke',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: 'api/revoke_key.php',
                        method: 'POST',
                        data: { key_id: keyId },
                        success: function(response) {
                            const result = JSON.parse(response);
                            if (result.success) {
                                Swal.fire('Revoked!', 'API key has been revoked.', 'success');
                                location.reload();
                            } else {
                                Swal.fire('Error', result.message, 'error');
                            }
                        }
                    });
                }
            });
        });

        // Add Secondary Email
        $('#addSecondaryEmailForm').on('submit', function(e) {
            e.preventDefault();
            
            $.ajax({
                url: 'settings/add_secondary_email.php',
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    const result = JSON.parse(response);
                    if (result.success) {
                        Swal.fire('Success', 'Verification email sent to ' + result.email, 'success');
                        location.reload();
                    } else {
                        Swal.fire('Error', result.message, 'error');
                    }
                }
            });
        });

        // Remove Secondary Email
        $('.remove-email').on('click', function(e) {
            e.preventDefault();
            const emailId = $(this).data('id');
            
            Swal.fire({
                title: 'Remove Email?',
                text: 'This email will be removed from your account.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Remove',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: 'settings/remove_email.php',
                        method: 'POST',
                        data: { email_id: emailId },
                        success: function(response) {
                            const result = JSON.parse(response);
                            if (result.success) {
                                Swal.fire('Removed!', 'Email has been removed.', 'success');
                                location.reload();
                            } else {
                                Swal.fire('Error', result.message, 'error');
                            }
                        }
                    });
                }
            });
        });

        // Remove Device
        $('.remove-device').on('click', function(e) {
            e.preventDefault();
            const deviceId = $(this).data('id');
            
            $.ajax({
                url: 'settings/remove_device.php',
                method: 'POST',
                data: { device_id: deviceId },
                success: function(response) {
                    const result = JSON.parse(response);
                    if (result.success) {
                        Swal.fire('Removed!', 'Device has been logged out.', 'success');
                        location.reload();
                    } else {
                        Swal.fire('Error', result.message, 'error');
                    }
                }
            });
        });

        // Set/Change PIN forms
        $('#setPinForm').on('submit', function(e) {
            e.preventDefault();
            setPin($(this).serialize());
        });

        $('#changePinForm').on('submit', function(e) {
            e.preventDefault();
            changePin($(this).serialize());
        });
    });

    // 2FA Functions
    function enable2FA() {
        $.ajax({
            url: 'settings/enable_2fa.php',
            method: 'GET',
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    $('#qrCodeImage').attr('src', result.qr_code);
                    $('#setupCode').val(result.secret);
                    
                    const modal = new bootstrap.Modal(document.getElementById('qrCodeModal'));
                    modal.show();
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            }
        });
    }

    function verify2FA() {
        const code = $('#verificationCode').val();
        
        if (!/^\d{6}$/.test(code)) {
            Swal.fire('Error', 'Please enter a valid 6-digit code', 'error');
            return;
        }
        
        $.ajax({
            url: 'settings/verify_2fa.php',
            method: 'POST',
            data: { code: code },
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '2FA Enabled!',
                        html: `<p>Two-factor authentication has been enabled for your account.</p>
                               <div class="alert alert-warning mt-3">
                                   <strong>Important:</strong> Save your backup codes:
                                   <div class="mt-2">${result.backup_codes.map(code => `<div class="backup-code">${code}</div>`).join('')}</div>
                               </div>`,
                        confirmButtonText: 'I have saved my backup codes'
                    }).then(() => {
                        bootstrap.Modal.getInstance(document.getElementById('qrCodeModal')).hide();
                        location.reload();
                    });
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            }
        });
    }

    function disable2FA() {
        Swal.fire({
            title: 'Disable 2FA?',
            text: 'This will reduce your account security.',
            icon: 'warning',
            input: 'text',
            inputLabel: 'Enter 2FA code',
            inputPlaceholder: '000000',
            showCancelButton: true,
            confirmButtonText: 'Disable',
            cancelButtonText: 'Cancel',
            inputValidator: (value) => {
                if (!/^\d{6}$/.test(value)) {
                    return 'Please enter a valid 6-digit code';
                }
            }
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: 'settings/disable_2fa.php',
                    method: 'POST',
                    data: { code: result.value },
                    success: function(response) {
                        const result = JSON.parse(response);
                        if (result.success) {
                            Swal.fire('Disabled!', '2FA has been disabled.', 'success');
                            location.reload();
                        } else {
                            Swal.fire('Error', result.message, 'error');
                        }
                    }
                });
            }
        });
    }

    function generateBackupCodes() {
        $.ajax({
            url: 'settings/generate_backup_codes.php',
            method: 'POST',
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    $('#backupCodesList').html(
                        result.codes.map(code => `
                            <div class="col">
                                <div class="backup-code">${code}</div>
                            </div>
                        `).join('')
                    );
                    $('#backupCodesDisplay').show();
                    
                    Swal.fire({
                        title: 'New Backup Codes Generated!',
                        html: `<p class="text-danger">Your old backup codes are no longer valid.</p>
                               <p>Save these new codes in a secure place:</p>`,
                        icon: 'warning',
                        confirmButtonText: 'I have saved them'
                    });
                }
            }
        });
    }

    function printBackupCodes() {
        window.print();
    }

    function downloadBackupCodes() {
        const codes = [];
        $('.backup-code').each(function() {
            codes.push($(this).text());
        });
        
        const content = `Backup Codes for <?php echo $userEmail; ?>\n\n` +
                       `Generated: ${new Date().toLocaleString()}\n\n` +
                       codes.join('\n') + '\n\n' +
                       'Keep these codes in a safe place. Each code can be used once.';
        
        const blob = new Blob([content], { type: 'text/plain' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'backup-codes.txt';
        a.click();
        window.URL.revokeObjectURL(url);
    }

    function copySetupCode() {
        const code = $('#setupCode').val();
        navigator.clipboard.writeText(code);
        Swal.fire('Copied!', 'Setup code copied to clipboard', 'success');
    }

    // PIN Functions
    function setPin(formData) {
        $.ajax({
            url: 'settings/set_pin.php',
            method: 'POST',
            data: formData,
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    Swal.fire('Success', 'Withdrawal PIN has been set.', 'success');
                    location.reload();
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            }
        });
    }

    function changePin(formData) {
        $.ajax({
            url: 'settings/change_pin.php',
            method: 'POST',
            data: formData,
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    Swal.fire('Success', 'Withdrawal PIN has been changed.', 'success');
                    location.reload();
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            }
        });
    }

    function resetPin() {
        Swal.fire({
            title: 'Reset Withdrawal PIN?',
            text: 'A reset link will be sent to your email.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Send Reset Link',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: 'settings/reset_pin.php',
                    method: 'POST',
                    success: function(response) {
                        const result = JSON.parse(response);
                        if (result.success) {
                            Swal.fire('Sent!', 'Reset link sent to your email.', 'success');
                        } else {
                            Swal.fire('Error', result.message, 'error');
                        }
                    }
                });
            }
        });
    }

    // Notification Settings
    function saveNotificationSettings() {
        const settings = {
            notify_login: $('#notifyLogin').is(':checked') ? 1 : 0,
            notify_withdrawal: $('#notifyWithdrawal').is(':checked') ? 1 : 0,
            notify_deposit: $('#notifyDeposit').is(':checked') ? 1 : 0,
            notify_trade: $('#notifyTrade').is(':checked') ? 1 : 0
        };
        
        $.ajax({
            url: 'settings/update_notifications.php',
            method: 'POST',
            data: settings,
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    Swal.fire('Saved!', 'Notification preferences updated.', 'success');
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            }
        });
    }

    // Device Functions
    function logoutAllDevices() {
        Swal.fire({
            title: 'Logout All Devices?',
            text: 'This will log you out from all devices except this one.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Logout All',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: 'settings/logout_all_devices.php',
                    method: 'POST',
                    success: function(response) {
                        const result = JSON.parse(response);
                        if (result.success) {
                            Swal.fire('Logged Out!', 'All other devices have been logged out.', 'success');
                            location.reload();
                        } else {
                            Swal.fire('Error', result.message, 'error');
                        }
                    }
                });
            }
        });
    }

    // Email Functions
    function changePrimaryEmail() {
        const modal = new bootstrap.Modal(document.getElementById('changeEmailModal'));
        modal.show();
    }

    function submitEmailChange() {
        const formData = $('#changeEmailForm').serialize();
        
        $.ajax({
            url: 'settings/change_email.php',
            method: 'POST',
            data: formData,
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Verification Sent',
                        html: `A verification email has been sent to <strong>${result.email}</strong>. 
                               <p class="mt-2">Please check your inbox and follow the instructions.</p>`
                    });
                    bootstrap.Modal.getInstance(document.getElementById('changeEmailModal')).hide();
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            }
        });
    }

    // Account Actions
    function exportData() {
        Swal.fire({
            title: 'Export Account Data',
            text: 'This may take a few minutes. We will email you when your data is ready.',
            icon: 'info',
            showCancelButton: true,
            confirmButtonText: 'Export',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: 'settings/export_data.php',
                    method: 'POST',
                    success: function(response) {
                        const result = JSON.parse(response);
                        if (result.success) {
                            Swal.fire('Requested!', 'Your data will be emailed shortly.', 'success');
                        } else {
                            Swal.fire('Error', result.message, 'error');
                        }
                    }
                });
            }
        });
    }

    function changePassword() {
        Swal.fire({
            title: 'Change Password',
            html: `<div class="text-start">
                    <div class="mb-3">
                        <label class="form-label">Current Password</label>
                        <input type="password" id="currentPassword" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">New Password</label>
                        <input type="password" id="newPassword" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Confirm New Password</label>
                        <input type="password" id="confirmPassword" class="form-control">
                    </div>
                   </div>`,
            focusConfirm: false,
            showCancelButton: true,
            confirmButtonText: 'Change Password',
            cancelButtonText: 'Cancel',
            preConfirm: () => {
                const current = document.getElementById('currentPassword').value;
                const newPass = document.getElementById('newPassword').value;
                const confirm = document.getElementById('confirmPassword').value;
                
                if (!current || !newPass || !confirm) {
                    Swal.showValidationMessage('Please fill in all fields');
                    return false;
                }
                
                if (newPass !== confirm) {
                    Swal.showValidationMessage('Passwords do not match');
                    return false;
                }
                
                if (newPass.length < 8) {
                    Swal.showValidationMessage('Password must be at least 8 characters');
                    return false;
                }
                
                return { current, new: newPass };
            }
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: 'settings/change_password.php',
                    method: 'POST',
                    data: result.value,
                    success: function(response) {
                        const result = JSON.parse(response);
                        if (result.success) {
                            Swal.fire('Changed!', 'Password has been updated.', 'success');
                        } else {
                            Swal.fire('Error', result.message, 'error');
                        }
                    }
                });
            }
        });
    }

    function deleteAccount() {
        Swal.fire({
            title: 'Delete Account?',
            html: `<div class="text-start">
                    <p class="text-danger">This action cannot be undone!</p>
                    <p>All your data will be permanently deleted including:</p>
                    <ul>
                        <li>Account information</li>
                        <li>Trading history</li>
                        <li>Wallet balances</li>
                        <li>API keys</li>
                    </ul>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="confirmDelete">
                        <label class="form-check-label" for="confirmDelete">
                            I understand this action is permanent
                        </label>
                    </div>
                   </div>`,
            icon: 'error',
            showCancelButton: true,
            confirmButtonText: 'Delete Account',
            confirmButtonColor: '#dc3545',
            cancelButtonText: 'Cancel',
            preConfirm: () => {
                if (!document.getElementById('confirmDelete').checked) {
                    Swal.showValidationMessage('Please confirm you understand');
                    return false;
                }
                return true;
            }
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Enter Password',
                    input: 'password',
                    inputLabel: 'Confirm your password to delete account',
                    showCancelButton: true,
                    confirmButtonText: 'Delete',
                    confirmButtonColor: '#dc3545'
                }).then((result2) => {
                    if (result2.isConfirmed) {
                        $.ajax({
                            url: 'settings/delete_account.php',
                            method: 'POST',
                            data: { password: result2.value },
                            success: function(response) {
                                const result = JSON.parse(response);
                                if (result.success) {
                                    Swal.fire({
                                        title: 'Account Deleted',
                                        text: 'Your account has been permanently deleted.',
                                        icon: 'success'
                                    }).then(() => {
                                        window.location.href = 'logout.php';
                                    });
                                } else {
                                    Swal.fire('Error', result.message, 'error');
                                }
                            }
                        });
                    }
                });
            }
        });
    }
    </script>
</body>
</html>