<?php session_start();
include 'includes/config.php';?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification</title>
    <style>
        .email-icon {
            font-size: 80px;
            color: #007bff;
            margin-bottom: 20px;
        }
        .text-primary {
            color: #007bff;
        }
        .verification-container {
            max-width: 500px;
            margin: 100px auto;
            padding: 40px;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            text-align: center;
        }
        .success-icon {
            font-size: 80px;
            color: #28a745;
            margin-bottom: 20px;
        }
        .error-icon {
            font-size: 80px;
            color: #dc3545;
            margin-bottom: 20px;
        }
        .btn-success {
            background: #28a745;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            color: white;
            text-decoration: none;
            display: inline-block;
        }
        .btn-success:hover {
            background: #218838;
            color: white;
        }
        .btn-outline-secondary {
            border: 2px solid #6c757d;
            color: #6c757d;
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
        }
        .btn-outline-secondary:hover {
            background: #6c757d;
            color: white;
        }
        .btn-primary {
            background: #007bff;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            color: white;
            text-decoration: none;
            display: inline-block;
        }
        .btn-primary:hover {
            background: #0056b3;
            color: white;
        }
        .btn-outline-primary {
            border: 2px solid #007bff;
            color: #007bff;
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
        }
        .btn-outline-primary:hover {
            background: #007bff;
            color: white;
        }
        .btn-link {
            color: #6c757d;
            text-decoration: none;
            font-weight: 500;
        }
        .btn-link:hover {
            color: #495057;
        }
        .d-grid {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .text-success {
            color: #28a745;
        }
        .text-danger {
            color: #dc3545;
        }
        .text-muted {
            color: #6c757d;
        }
        .fw-bold {
            font-weight: bold;
        }
        .mb-3 {
            margin-bottom: 1rem;
        }
        .mb-4 {
            margin-bottom: 1.5rem;
        }
    </style>
</head>

<?php
if(isset($_GET['reg'])) {?>

<body style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px 0; display: flex; align-items: center;">
    <div class="verification-container">
        <div class="email-icon">
            <i class="fas fa-envelope"></i>
        </div>
        
        <h2 class="text-primary fw-bold mb-3">Verify Your Email Address</h2>
        
        <p class="text-muted mb-4">
            An email verification link has been sent to your provided email address. Please check your inbox and click the link to verify your account.
        </p>
        
        <div class="d-grid gap-2">
            <a href="resend-verification.php" class="btn btn-primary">Resend Verification Email</a>
            <a href="login.php" class="btn btn-outline-secondary">Back to Login</a>
        </div>
    </div>
</body>
<?php

}elseif(isset($_GET['token'])){



$token = $_GET['token'];
$message = 'The verification link is invalid or has expired.';



// Check if token exists and is not expired
$sql = "SELECT id, email FROM users WHERE verification_token = '$token' AND verification_token_expires > NOW() AND email_verified = '0'";
$result = mysqli_query($conn, $sql);

    if(mysqli_num_rows($result) > 0) {
        $user = mysqli_fetch_assoc($result);
        $user_id = $user['id'];
        
        // Mark email as verified
        $update_sql = "UPDATE users SET email_verified = '1', verification_token = NULL, verification_token_expires = NULL WHERE id = '$user_id'";
        if(mysqli_query($conn, $update_sql)) {
            // Success case
            ?>
            <body style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px 0; display: flex; align-items: center;">
                <div class="verification-container">
                    <div class="success-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    
                    <h2 class="text-success fw-bold mb-3">Email Verified Successfully!</h2>
                    
                    <p class="text-muted mb-4">
                        Your email address has been successfully verified. You can now complete your profile and start using your account.
                    </p>
                    
                    <div class="d-grid gap-2">
                        <a href="login.php" class="btn btn-success">Login To Continue</a>
                        
                    </div>
                </div>
            </body>
            <?php
        } else {
            // Database update failed
            $message = 'Database error. Please try again.';
            ?>
            <body style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px 0; display: flex; align-items: center;">
                <div class="verification-container">
                    <div class="error-icon">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    
                    <h2 class="text-danger fw-bold mb-3">Email Verification Failed</h2>
                    
                    <p class="text-muted mb-4">
                        <?php echo $message; ?>
                    </p>
                    
                    <div class="d-grid gap-2">
                        <a href="resend-verification.php" class="btn btn-primary">Get New Verification Link</a>
                        <a href="login.php" class="btn btn-outline-primary">Try to Login</a>
                        <a href="../contact.php" class="btn btn-link">Contact Support</a>
                    </div>
                </div>
            </body>
            <?php
        }
    } else {
        // Token is invalid or expired
        $check_sql = "SELECT email FROM users WHERE verification_token = '$token'";
        $check_result = mysqli_query($conn, $check_sql);
        $user_email = '';
        
        if(mysqli_num_rows($check_result) > 0) {
            $user_data = mysqli_fetch_assoc($check_result);
            $user_email = $user_data['email'];
            $message = 'The verification link has expired.';
        }
        ?>
        <body style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px 0; display: flex; align-items: center;">
            <div class="verification-container">
                <div class="error-icon">
                    <i class="fas fa-times-circle"></i>
                </div>
                
                <h2 class="text-danger fw-bold mb-3">Email Verification Failed</h2>
                
                <p class="text-muted mb-4">
                    <?php echo $message; ?>
                </p>
                
                <div class="d-grid gap-2">
                    <?php if(!empty($user_email)): ?>
                        <a href="resend-verification.php?email=<?php echo urlencode($user_email); ?>" class="btn btn-primary">
                            Resend Verification Email
                        </a>
                    <?php else: ?>
                        <a href="resend-verification.php" class="btn btn-primary">
                            Get New Verification Link
                        </a>
                    <?php endif; ?>
                    
                    <a href="login.php" class="btn btn-outline-primary">Try to Login</a>
                    <a href="contact-support.php" class="btn btn-link">Contact Support</a>
                </div>
            </div>
        </body>
        <?php
    }

}
?>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</html>