<?php session_start();

?>
<!DOCTYPE html>
<html lang="en">


<?php include("includes/head.php") ?>

<body>

    <!--==========================   Preloader Start  ==========================-->
    
    <!--==========================  Preloader End  ==========================-->

    <div class="wrapper">
        <!--==========================   Header Start  ==========================-->
            <?php include("includes/header.php") ?>

        <!--==========================  Header End  ==========================-->
        <main>
            <!--==========================  Banner Section Start  ==========================-->
            

<!--==========================  Banner Section Start  ==========================-->
<section class="banner-one-section bg--black">
    <div class="container position-relative">
        <div class="shape-icon d-none d-lg-block">
            <img src="assets/svg/twostar.svg" alt="twostar">
            <img src="assets/svg/star-4.svg" alt="star">
            <img src="assets/svg/star-4.svg" alt="star">
        </div>

        <div class="row row-gap-5 justify-content-between">
            <div class="col-lg-6 col-xl-5 align-self-center order-1 order-lg-0">
                <div class="banner_content">
                    <div class="banner_content--sub text--base fs-20 fw-medium right-reveal">
                        <img src="assets/svg/arrow-right.svg" alt="arrow">
                        AI-Powered Trading for Smarter Profits
                    </div>

                    <h1 class="right-reveal">
                        Advanced Forex & Stock
                        <span class="text--base">AI Trading Investments</span>
                        <i class="flaticon-compass text--base-two"></i>
                    </h1>

                    <p class="fs-18 fw-medium right-reveal">
                        Whether you’re a beginner or a professional trader, our AI-driven
                        trading engine analyzes market data in real-time to deliver
                        smarter, faster, and more consistent trading decisions.
                    </p>

                    
                    <?php if(isset($_SESSION['user_id'])) {?>
                        <div class="d-flex flex-wrap gap-4">
                            <a href="dashboard/index.php" class="btn btn-outline--base right-reveal">
                                Access Dashboard <i class="flaticon-arrow-upper-right"></i>
                            </a>
                            <a href="dashboard/wallets.php" class="btn btn--base-three right-reveal" style="background: #3424e6 !important;color:#fff !important">
                                Access Wallet  <i class="flaticon-arrow-upper-right"></i>
                            </a>
                        </div>

                        <?php }elseif(!isset($_SESSION['user_id'])) {?>
                        
                        <div class="d-flex flex-wrap gap-4">
                            <a href="login.php" class="btn btn--base-two right-reveal">
                                Access Your Account <i class="flaticon-arrow-upper-right"></i>
                            </a>
                            <a href="register.php" class="btn btn-outline--base right-reveal">
                                Start Trading Now <i class="flaticon-arrow-upper-right"></i>
                            </a>
                        </div>
                        <?php }?>
                </div>
            </div>

            <div class="col-lg-6 align-self-center">
                <div class="banner-img scaleUp">
                    <img src="assets/hero-img-2.png" alt="banner">
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Banner Section End  ==========================-->


<!--==========================  About Section Start  ==========================-->
<section class="about-section bg--black-two py-120">
    <div class="container position-relative">
        <div class="about-shape d-none d-lg-block">
            <img src="assets/svg/twostar.svg" alt="star">
            <img src="assets/svg/star-1.svg" alt="star">
        </div>

        <div class="row row-gap-5">
            <div class="col-xl-6 align-self-center">
                <div class="about-img pe-xl-4 scaleUp">
                    <img src="assets/images/about/about1.png" alt="about image" class="img-fluid">
                </div>
            </div>

            <div class="col-xl-6 align-self-center">
                <div class="section-content">
                    <h6 class="right-reveal">About Us</h6>
                    <h2 class="right-reveal">
                        Building Profitable Traders with AI Precision
                    </h2>

                    <p class="right-reveal">
                        At <strong>Trade Mastery</strong>, we believe profitable trading
                        is achieved through technology, discipline, and data-driven
                        strategies. Our AI trading system combines machine learning,
                        technical indicators, and real-time market analysis to execute
                        trades with high accuracy and controlled risk.
                    </p>
                </div>

                <div class="d-flex flex-wrap gap-4 my-4 my-lg-5">
                    <div class="info-box right-reveal">
                        <div class="fs-40 text--base fw-bold">
                            <span class="odometer" data-odometer-final="7">3</span>+
                        </div>
                        <p>Years of AI Trading Experience</p>
                    </div>

                    <div class="info-box right-reveal">
                        <div class="fs-40 text--base fw-bold">
                            <span class="odometer" data-odometer-final="25000">1000</span>+
                        </div>
                        <p>Active Traders Worldwide</p>
                    </div>
                </div>

                <a href="about.php" class="btn btn--base-two right-reveal">
                    Explore More <i class="flaticon-arrow-upper-right"></i>
                </a>
            </div>
        </div>
    </div>
</section>
<!--==========================  About Section End  ==========================-->


<!--==========================  Services Section Start  ==========================-->
<section class="services-section bg--black py-120">
    <div class="container position-relative">
        <div class="services-shape d-none d-lg-block">
            <img src="assets/svg/balance-1.svg" alt="balance">
            <img src="assets/svg/balance-2.svg" alt="balance">
        </div>

        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8">
                <div class="section-content text-center">
                    <h6 class="top-reveal">Our Services</h6>
                    <h2 class="top-reveal">
                        Smart Trading Solutions for Every Investor
                    </h2>
                    <p class="top-reveal">
                        Our platform delivers fully automated and semi-automated
                        AI trading solutions designed to maximize profit while
                        managing risk efficiently across global markets.
                    </p>
                </div>
            </div>
        </div>

        <div class="row row-gap-4 mt-60 justify-content-center">
            <div class="col-12 position-relative bottom-reveal">
                <div class="services-slider swiper">
                    <div class="swiper-wrapper">

                        <div class="swiper-slide">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-balance-sheet"></i>
                                </div>
                                <h3><a href="services-details.php">AI Equity Trading</a></h3>
                                <p>
                                    Automated stock trading powered by AI algorithms
                                    that analyze market trends and execute precision trades.
                                </p>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-chart"></i>
                                </div>
                                <h3><a href="services-details.php">Market Intelligence</a></h3>
                                <p>
                                    Real-time market data, predictive analytics, and
                                    AI-driven insights for smarter trading decisions.
                                </p>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-forex"></i>
                                </div>
                                <h3><a href="services-details.php">Forex AI Trading</a></h3>
                                <p>
                                    High-frequency AI strategies designed for major
                                    and minor currency pairs with optimized risk control.
                                </p>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-chart-1"></i>
                                </div>
                                <h3><a href="services-details.php">Stock Market Bots</a></h3>
                                <p>
                                    Intelligent trading bots that monitor volatility,
                                    volume, and momentum for profitable entries.
                                </p>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-graph"></i>
                                </div>
                                <h3><a href="services-details.php">Technical AI Analysis</a></h3>
                                <p>
                                    AI-enhanced technical analysis using indicators,
                                    price action, and trend recognition models.
                                </p>
                            </div>
                        </div>

                    </div>
                    <div class="swiper-pagination"></div>
                </div>

                <div class="slider-btn">
                    <div class="btn-slider-prev services-prev">
                        <i class="fa-solid fa-chevron-left"></i>
                    </div>
                    <div class="btn-slider-next services-next">
                        <i class="fa-solid fa-chevron-right"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Services Section End  ==========================-->



        <!--==========================  Trade Section Start  ==========================-->
<section class="trade-section bg--black-two py-120">
    <div class="container position-relative">
        <div class="trade-shape d-none d-lg-block">
            <img src="assets/svg/twostar.svg" alt="star">
            <img src="assets/svg/calculator.svg" alt="calculator">
        </div>

        <div class="row row-gap-5">
            <div class="col-xl-6 align-self-center">
                <div class="trade-img me-xl-4 scaleUp">
                    <img src="assets/images/trade/trade.png" alt="trade platform" class="img-fluid">
                </div>
            </div>

            <div class="col-xl-6 align-self-center">
                <div class="section-content">
                    <h6 class="right-reveal">Trade on Our Platform</h6>
                    <h2 class="right-reveal">
                        A Powerful All-in-One AI Trading Platform Built for Speed & Accuracy
                    </h2>
                    <p class="right-reveal">
                        Our AI trading platform is engineered to deliver institutional-grade
                        performance for retail traders. Using real-time data feeds, smart
                        order execution, and automated risk management, we help traders
                        capitalize on market opportunities with confidence.
                    </p>
                </div>

                <ul class="trade-list py-4 mt-2 mb-3">
                    <li class="right-reveal">Global Forex Market Access</li>
                    <li class="right-reveal">Commodities & Market Indices</li>
                    <li class="right-reveal">Real-Time Price Feeds</li>
                    <li class="right-reveal">Stocks & Equity Instruments</li>
                    <li class="right-reveal">Cryptocurrency Trading Pairs</li>
                    <li class="right-reveal">Advanced AI-Driven Charting Tools</li>
                </ul>

                <a href="register.php" class="btn btn--base-two right-reveal">
                    Sign Up Now <i class="flaticon-arrow-upper-right"></i>
                </a>
            </div>
        </div>
    </div>
</section>
<!--==========================  Trade Section End  ==========================-->


<!--==========================  Number Section Start  ==========================-->
<div class="number-section py-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="number-count">

                    <div class="number-box left-reveal">
                        <div class="fs-60 fw-bold">
                            $<span class="odometer" data-odometer-final="2700">1200</span>K+
                        </div>
                        <p>Total Capital Traded</p>
                    </div>

                    <div class="number-box left-reveal">
                        <div class="fs-60 fw-bold">
                            <span class="odometer" data-odometer-final="860">400</span>+
                        </div>
                        <p>Professional Traders</p>
                    </div>

                    <div class="number-box left-reveal">
                        <div class="fs-60 fw-bold">
                            <span class="odometer" data-odometer-final="14000">5000</span>+
                        </div>
                        <p>Successful AI Trades</p>
                    </div>

                    <div class="number-box left-reveal">
                        <div class="fs-60 fw-bold">
                            <span class="odometer" data-odometer-final="130">45</span>+
                        </div>
                        <p>Industry Awards</p>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!--==========================  Number Section End  ==========================-->


<!--==========================  Trade Market Section Start  ==========================-->
<section class="trade-smartet-section bg--black py-120">
    <div class="container position-relative">
        <div class="trade-smartet-shape d-none d-lg-block">
            <img src="assets/svg/twostar.svg" alt="star">
            <img src="assets/svg/balance-3.svg" alt="balance">
        </div>

        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8">
                <div class="section-content text-center">
                    <h6 class="top-reveal">Trade Smarter</h6>
                    <h2 class="top-reveal">
                        Institutional-Grade Spreads, Speed & Liquidity
                    </h2>
                    <p class="top-reveal">
                        Experience ultra-low spreads, lightning-fast execution, and
                        deep liquidity across multiple asset classes. Our AI routing
                        system ensures optimal pricing and minimal slippage.
                    </p>
                </div>
            </div>
        </div>

        <div class="row mt-60">
            <div class="col-lg-12">
                <div class="bg--black-two trabe-info bottom-reveal">

                    <div class="table-nav d-flex flex-wrap gap-4 align-items-center justify-content-between">
                        <ul class="nav nav-pills">
                            <li class="nav-item"><button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-all">All</button></li>
                            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-forex">Forex</button></li>
                            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-metals">Metals</button></li>
                            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-indices">Indices</button></li>
                            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-commodities">Commodities</button></li>
                            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-stocks">Stocks</button></li>
                            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-cryptos">Cryptos</button></li>
                        </ul>

                        <form>
                            <input type="search" placeholder="Search trading instruments">
                            <button type="submit">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                        </form>
                    </div>

                    <div class="text-center mt-4">
                        <a href="market.php" class="btn btn--base-two">
                            View Full Market <i class="flaticon-arrow-upper-right"></i>
                        </a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Trade Market Section End  ==========================-->
<!--==========================  Pricing Section Start  ==========================-->
<section class="pricing-section bg--black-two py-120">
    <div class="container position-relative">
        <div class="pricing-shape d-none d-lg-block">
            <img src="assets/svg/analysis-1.svg" alt="star">
            <img src="assets/svg/analysis-2.svg" alt="star">
        </div>
        <div class="row row-gap-3 ">
            <div class="col-lg-6 align-self-end">
                <div class="section-content">
                    <h6 class="right-reveal">AI Bot Plans</h6>
                    <h2 class="mb-0 right-reveal">Choose Your AI Trading Bot</h2>
                </div>
            </div>
            <div class="col-lg-6 align-self-end">
                <div class="section-content">
                    <p class="right-reveal">Select from our range of AI-powered trading bots, each designed for different investment levels and trading strategies. All bots feature 24/7 market analysis and automated risk management.</p>
                </div>
            </div>
        </div>
        <div class="row mt-60 row-gap-4 justify-content-center">
            <div class="col-12 bottom-reveal">
                <div class="pricing-slide swiper">
                    <div class="swiper-wrapper">
                        <?php
                        // Fetch bot plans from database
                        $bot_plans_query = mysqli_query($conn, "
                            SELECT * FROM trading_bot_plans 
                            WHERE is_active = 1 
                            ORDER BY sort_order ASC
                        ");
                        
                        while($plan = mysqli_fetch_assoc($bot_plans_query)):
                        ?>
                        <div class="swiper-slide">
                            <div class="pricing-content">
                                <div class="pricing-header">
                                    <h6 class="mb-2"><?php echo htmlspecialchars($plan['plan_name']); ?></h6>
                                    <h2 class="mb-2">$<?php echo number_format($plan['subscription_fee'], 0); ?><sub class="fs-16 fw-normal">/Month</sub></h2>
                                    <p><?php echo $plan['daily_roi_percentage']; ?>% Daily ROI</p>
                                </div>
                                <div class="pricing-body">
                                    <ul>
                                        <li><?php echo $plan['markets_covered']; ?>+ Markets Covered</li>
                                        <li><?php echo $plan['strategy_types']; ?> Trading Strategies</li>
                                        <li><?php echo $plan['trading_accuracy']; ?>% Trading Accuracy</li>
                                        <?php if($plan['has_machine_learning']): ?>
                                        <li>Machine Learning Algorithms</li>
                                        <?php endif; ?>
                                        <?php if($plan['has_multi_market']): ?>
                                        <li>Multi-Market Scanning</li>
                                        <?php endif; ?>
                                        <?php if($plan['has_strategy_blending']): ?>
                                        <li>Strategy Blending</li>
                                        <?php endif; ?>
                                        <li><?php echo $plan['support_level']; ?> Support</li>
                                    </ul>
                                </div>
                                <div class="pricing-footer">
                                    <a href="register.php?plan=<?php echo $plan['id']; ?>" class="btn btn--black-two">Subscribe Now</a>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Pricing Section End  ==========================-->
<!--==========================  People Section Start  ==========================-->
<section class="people-trust-section bg--black py-120">
    <div class="container position-relative">
        <div class="people-shape d-none d-lg-block">
            <img src="assets/svg/twostar.svg" alt="star">
            <img src="assets/svg/balance-4.svg" alt="star">
        </div>
        <div class="row justify-content-center">
            <div class="col-xxl-6 col-xl-7 col-lg-8">
                <div class="section-content text-center">
                    <h6 class="top-reveal">Platform Success</h6>
                    <h2 class="top-reveal">Trusted by Thousands of AI Traders</h2>
                    <p class="top-reveal">Join our community of successful traders who trust our AI algorithms for consistent returns. Our platform processes millions of trades with 99.7% uptime.</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 mt-5">
                <ul class="nav nav-pills gap-4 justify-content-center " id="people-tab" role="tablist">
                    <li class="nav-item bottom-reveal" role="presentation">
                        <button class="nav-link " data-bs-toggle="pill" data-bs-target="#people-one"
                            role="tab">
                            <i class="flaticon-cam-recorder"></i> AI Bot Demo
                        </button>
                    </li>
                    <li class="nav-item bottom-reveal" role="presentation">
                        <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#people-two"
                            role="tab">
                            <i class="flaticon-live-1"></i> Live Trading Results
                        </button>
                    </li>
                    <li class="nav-item bottom-reveal" role="presentation">
                        <button class="nav-link" data-bs-toggle="pill" data-bs-target="#people-three"
                            role="tab">
                            <i class="flaticon-cam-recorder"></i> Tutorial Videos
                        </button>
                    </li>
                </ul>
            </div>

            <div class="col-12 mt-60">
                <div class="tab-content bottom-reveal" id="people-tabContent">
                    <div class="tab-pane fade " id="people-one" role="tabpanel" tabindex="0">
                        <a class="people-video video-container"
                            href="https://www.youtube.com/watch?v=SjJhuZQlkbA" data-fancybox>
                            <img src="assets/images/video/video2.jpg" alt="AI Bot Demo">
                            <div class="play-button">
                                <span class="play-icon"><i class="fa fa-solid fa-play"></i></span>
                            </div>
                        </a>
                        <div class="row mt-5 row-gap-5 justify-content-between">
                            <div class="col-xl-5 col-lg-6">
                                <div class="section-content">
                                    <h2>How Our AI Bots Work</h2>
                                    <p>
                                        Watch our AI trading bots in action. See how machine learning algorithms analyze market patterns in real-time, execute trades with precision, and manage risk automatically. Learn about our proprietary neural networks that achieve 99.7% accuracy.
                                    </p>
                                </div>
                            </div>
                            <div class="col-xl-5 col-lg-6">
                                <ul class="people-list">
                                    <li>Real-time Market Analysis</li>
                                    <li>Pattern Recognition</li>
                                    <li>Risk Management Algorithms</li>
                                    <li>Automated Trade Execution</li>
                                    <li>Performance Analytics</li>
                                    <li>24/7 Market Monitoring</li>
                                    <li>Multi-Exchange Support</li>
                                    <li>Portfolio Optimization</li>
                                </ul> 
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade show active" id="people-two" role="tabpanel" tabindex="0">
                        <a class="people-video video-container"
                            href="https://www.youtube.com/watch?v=SjJhuZQlkbA" data-fancybox>
                            <img src="assets/images/video/video1.jpg" alt="Live Trading Results">
                            <div class="play-button">
                                <span class="play-icon"><i class="fa fa-solid fa-play"></i></span>
                            </div>
                        </a>
                        <div class="row mt-5 row-gap-5 justify-content-between">
                            <div class="col-xl-5 col-lg-6">
                                <div class="section-content">
                                    <h2>Real Trading Performance</h2>
                                    <p>
                                        See live trading results from our AI bots. Watch how our algorithms adapt to market conditions, execute profitable trades, and manage risk in real-time. Our bots process millions of data points to make informed trading decisions 24/7.
                                    </p>
                                </div>
                            </div>
                            <div class="col-xl-5 col-lg-6">
                                <ul class="people-list">
                                    <li>24/7 Automated Trading</li>
                                    <li>Real-time Profit Tracking</li>
                                    <li>Risk-adjusted Returns</li>
                                    <li>Performance Analytics</li>
                                </ul>
                                <?php
                                // Fetch platform statistics
                                $monthly_volume = mysqli_query($conn, "
                                    SELECT SUM(amount) as monthly_volume 
                                    FROM bot_transactions 
                                    WHERE MONTH(transaction_date) = MONTH(CURRENT_DATE())
                                ")->fetch_assoc();
                                
                                $yearly_volume = mysqli_query($conn, "
                                    SELECT SUM(amount) as yearly_volume 
                                    FROM bot_transactions 
                                    WHERE YEAR(transaction_date) = YEAR(CURRENT_DATE())
                                ")->fetch_assoc();
                                ?>
                                <div class="row mt-4 row-gap-4">
                                    <div class="col-6">
                                        <div class="people-box">
                                            <h2 class="fw-bold text--base mb-2">$<span class="odometer"
                                                    data-odometer-final="<?php echo intval($monthly_volume['monthly_volume']/1000000); ?>">2</span>M</h2>
                                            <p>Monthly Volume</p>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="people-box">
                                            <h2 class="fw-bold text--base mb-2">$<span class="odometer"
                                                    data-odometer-final="<?php echo intval($yearly_volume['yearly_volume']/1000000); ?>">5</span>M</h2>
                                            <p>Yearly Volume</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="people-three" role="tabpanel" tabindex="0">
                        <a class="people-video video-container"
                            href="https://www.youtube.com/watch?v=SjJhuZQlkbA" data-fancybox>
                            <img src="assets/images/video/video3.jpg" alt="Tutorial Videos">
                            <div class="play-button">
                                <span class="play-icon"><i class="fa fa-solid fa-play"></i></span>
                            </div>
                        </a>
                        <div class="row mt-5 row-gap-5 justify-content-between">
                            <div class="col-xl-5 col-lg-6">
                                <div class="section-content">
                                    <h2>Learn AI Trading</h2>
                                    <p>
                                        Master AI trading with our comprehensive tutorials. Learn how to set up your trading bots, configure risk parameters, monitor performance, and optimize your strategies for maximum returns. Perfect for both beginners and experienced traders.
                                    </p>
                                </div>
                            </div>
                            <div class="col-xl-5 col-lg-6">
                                <ul class="people-list">
                                    <li>Bot Setup Tutorials</li>
                                    <li>Risk Management Guides</li>
                                    <li>Performance Monitoring</li>
                                    <li>Strategy Optimization</li>
                                </ul>
                                <div class="row mt-4 row-gap-4">
                                    <div class="col-6">
                                        <div class="people-box">
                                            <h2 class="fw-bold text--base mb-2">50<span class="odometer"
                                                    data-odometer-final="50">+</span></h2>
                                            <p>Tutorial Videos</p>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="people-box">
                                            <h2 class="fw-bold text--base mb-2">24<span class="odometer"
                                                    data-odometer-final="7">/7</span></h2>
                                            <p>Support Available</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--==========================  People Section End  ==========================-->
<!--==========================  Testimonial Section Start  ==========================-->
<section class="testimonial-section bg--black-two py-120">
    <div class="container position-relative">
        <div class="testimonial-shape d-none d-lg-block">
            <img src="assets/svg/twostar.svg" alt="star">
            <img src="assets/svg/maneyPlant.svg" alt="money Plant">
        </div>
        <div class="row row-gap-2">
            <div class="col-lg-6 align-self-end">
                <div class="section-content">
                    <h6 class="right-reveal">Success Stories</h6>
                    <h2 class="mb-2 right-reveal">What Our Traders Say</h2>
                </div>
            </div>
            <div class="col-lg-6 align-self-end">
                <div class="section-content">
                    <p class="right-reveal">Hear from real traders who have achieved consistent returns using our AI trading platform. Our community includes thousands of satisfied users worldwide.</p>
                </div>
            </div>
        </div>
        <div class="row mt-60">
            <div class="col-12 position-relative bottom-reveal">
                <div class="testimonial-slide swiper">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <div class="start-client">
                                    <img src="assets/svg/star-5.svg" alt="star">
                                </div>
                                <div class="client-body">
                                    <img src="assets/svg/quite.svg" alt="quite">
                                    <p class="client-text">
                                        "I've been using the AI Alpha bot for 6 months and achieved a 45% return. The automated trading works perfectly while I sleep. Best investment I've made!"
                                    </p>
                                    <div class="client-info d-flex gap-3 align-self-center">
                                        <img src="assets/images/client/client1.png" alt="client">
                                        <div class="text">
                                            <h4 class="mb-2">Robert Jenkins</h4>
                                            <p>AI Alpha Bot User</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <div class="start-client">
                                    <img src="assets/svg/star-5.svg" alt="star">
                                </div>
                                <div class="client-body">
                                    <img src="assets/svg/quite.svg" alt="quite">
                                    <p class="client-text">
                                        "The AI Quantum bot's multi-market scanning found opportunities I would have missed. 68% returns in 4 months with minimal effort on my part."
                                    </p>
                                    <div class="client-info d-flex gap-3 align-self-center">
                                        <img src="assets/images/client/client2.png" alt="client">
                                        <div class="text">
                                            <h4 class="mb-2">Sarah Johnson</h4>
                                            <p>AI Quantum Bot User</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <div class="start-client">
                                    <img src="assets/svg/star-5.svg" alt="star">
                                </div>
                                <div class="client-body">
                                    <img src="assets/svg/quite.svg" alt="quite">
                                    <p class="client-text">
                                        "As someone new to trading, the AI Sigma bot made it easy to start. The 92% accuracy rate is real - I've had consistent profits every week."
                                    </p>
                                    <div class="client-info d-flex gap-3 align-self-center">
                                        <img src="assets/images/client/client3.png" alt="client">
                                        <div class="text">
                                            <h4 class="mb-2">Michael Chen</h4>
                                            <p>AI Sigma Bot User</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <div class="start-client">
                                    <img src="assets/svg/star-5.svg" alt="star">
                                </div>
                                <div class="client-body">
                                    <img src="assets/svg/quite.svg" alt="quite">
                                    <p class="client-text">
                                        "The AI Omega bot with dedicated manager support has been exceptional. We scaled from $50k to $125k in 8 months. Professional-grade tools."
                                    </p>
                                    <div class="client-info d-flex gap-3 align-self-center">
                                        <img src="assets/images/client/client1.png" alt="client">
                                        <div class="text">
                                            <h4 class="mb-2">David Wilson</h4>
                                            <p>AI Omega Bot User</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <div class="start-client">
                                    <img src="assets/svg/star-5.svg" alt="star">
                                </div>
                                <div class="client-body">
                                    <img src="assets/svg/quite.svg" alt="quite">
                                    <p class="client-text">
                                        "24/7 trading with consistent 12-15% monthly returns. The risk management features give me peace of mind. Highly recommended!"
                                    </p>
                                    <div class="client-info d-flex gap-3 align-self-center">
                                        <img src="assets/images/client/client2.png" alt="client">
                                        <div class="text">
                                            <h4 class="mb-2">Emma Rodriguez</h4>
                                            <p>AI Alpha Bot User</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <div class="slider-btn">
                    <div class="btn-slider-prev testi-prev">
                        <i class="fa-solid fa-chevron-left"></i>
                    </div>
                    <div class="btn-slider-next testi-next">
                        <i class="fa-solid fa-chevron-right"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Testimonial Section End  ==========================-->
<!--==========================  Faq Section Start  ==========================-->
<section class="faq-section bg--black py-120">
    <div class="container position-relative">
        <div class="faq-shape d-none d-lg-block">
            <img src="assets/svg/bank.svg" alt="bank">
            <img src="assets/svg/balance-5.svg" alt="balance">
        </div>
        <div class="row justify-content-center">
            <div class="col-xl-7 col-lg-8">
                <div class="section-content text-center">
                    <h6 class="top-reveal">AI Trading FAQs</h6>
                    <h2 class="top-reveal">Frequently Asked Questions</h2>
                    <p class="top-reveal">Get answers to common questions about AI trading, bot performance, and platform features.</p>
                </div>
            </div>
        </div>
        <div class="row mt-60 row-gap-5">
            <div class="col-lg-6 align-self-center">
                <img src="assets/images/faq/faq.png" alt="AI Trading FAQ" class="img-fluid scaleUp">
            </div>
            <div class="col-lg-6 align-self-center">
                <div class="accordion custom--accordion" id="faqExample">
                    <?php
                    // Fetch FAQ items from database
                    $faq_query = mysqli_query($conn, "
                        SELECT fi.*, fc.name as category_name 
                        FROM faq_items fi 
                        LEFT JOIN faq_categories fc ON fi.category_id = fc.id 
                        WHERE fi.is_active = 1 
                        AND fc.name IN ('Trading Bots', 'Funding & Deposits', 'Withdrawals', 'Account Verification', 'Security')
                        ORDER BY fi.id LIMIT 5
                    ");
                    $faq_count = 0;
                    while($faq = mysqli_fetch_assoc($faq_query)):
                        $faq_count++;
                        $active = $faq_count == 1 ? 'show' : '';
                        $collapsed = $faq_count == 1 ? '' : 'collapsed';
                    ?>
                    <div class="accordion-item bottom-reveal">
                        <h2 class="accordion-header">
                            <button class="accordion-button <?php echo $collapsed; ?>" type="button"
                                data-bs-toggle="collapse" data-bs-target="#faq<?php echo $faq_count; ?>" 
                                aria-expanded="<?php echo $faq_count == 1 ? 'true' : 'false'; ?>">
                                <?php echo htmlspecialchars($faq['question']); ?>
                            </button>
                        </h2>
                        <div id="faq<?php echo $faq_count; ?>" class="accordion-collapse collapse <?php echo $active; ?>" data-bs-parent="#faqExample">
                            <div class="accordion-body">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Faq Section End  ==========================-->
<!--==========================  Blog Section Start  ==========================-->
<section class="blog-section bg--black-two py-120">
    <div class="container position-relative">
        <div class="blog-shape d-none d-lg-block">
            <img src="assets/svg/balance-6.svg" alt="balance">
            <img src="assets/svg/maneyPlant.svg" alt="balance">
        </div>
        <div class="row row-gap-4">
            <div class="col-lg-6 align-self-center">
                <div class="section-content">
                    <h6 class="right-reveal">AI Insights</h6>
                    <h2 class="mb-0 right-reveal">Latest AI Trading News</h2>
                </div>
            </div>
            <div class="col-lg-6 align-self-center">
                <div class="float-lg-end left-reveal">
                    <a href="blog.php" class="btn btn--base-two ">
                        View All Insights <i class="flaticon-arrow-upper-right"></i>
                    </a>
                </div>
            </div>
        </div>
        <div class="row mt-60 row-gap-4">
            <div class="col-lg-6 right-reveal">
                <div class="blog-item">
                    <img src="assets/images/blog/blog1.jpg" alt="AI Trading Strategies" class="img-fluid w-100">
                    <ul class="blog-list">
                        <li>AI Strategies</li>
                        <li><?php echo date('d F, Y', strtotime('-2 days')); ?></li>
                    </ul>
                    <h4>
                        <a href="blog-details.php">
                            How Machine Learning Revolutionizes Cryptocurrency Trading
                        </a>
                    </h4>
                    <a href="blog-details.php" class="btn btn--base-two">
                        Read More <i class="flaticon-arrow-upper-right"></i>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 left-reveal">
                <div class="blog-item">
                    <img src="assets/images/blog/blog2.jpg" alt="Risk Management" class="img-fluid w-100">
                    <ul class="blog-list">
                        <li>Risk Management</li>
                        <li><?php echo date('d F, Y', strtotime('-5 days')); ?></li>
                    </ul>
                    <h4>
                        <a href="blog-details.php">
                            AI-Powered Risk Management: Protecting Your Capital
                        </a>
                    </h4>
                    <a href="blog-details.php" class="btn btn--base-two">
                        Read More <i class="flaticon-arrow-upper-right"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Blog Section End  ==========================-->
<!--==========================  Call-to-action Section Start  ==========================-->
<section class="call-to-action-section bg--black-two">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="call-action-box">
                    <div class="call-shape">
                        <img src="assets/svg/twostar.svg" alt="star">
                    </div>
                    <div class="row row-gap-5">
                        <div class="col-lg-6 align-self-center order-1 order-lg-0">
                            <div class="call-text text-center text-lg-start">
                                <span class="text--base pb-3 right-reveal">Start AI Trading Today</span>
                                <h2 class="mb-4 right-reveal">Join the Future of Automated Trading with AI Technology</h2>
                                <a href="register.php" class="btn btn--base-two right-reveal">
                                    Create Free Account <i class="flaticon-arrow-upper-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-6 align-self-center">
                            <div class="call-img text-lg-end text-center scaleUp">
                                <img src="assets/images/call/call-img.png" alt="AI Trading Platform" class="img-fluid m-auto">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--==========================  Call-to-action Section End  ==========================--></main>
        <!-- ==================== Footer Start Here ==================== -->
       <?php include("includes/footer.php") ?>
        <!-- ==================== Footer End Here ==================== -->
    </div>
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>


    <!-- Jquery js -->
    <script data-cfasync="false" src="../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- gsap Js -->
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <!-- Bootstrap Bundle Js -->
    <script src="assets/js/boostrap.bundle.min.js"></script>
    <!-- Scroll Reveal Js -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <!-- Swiper Bundle Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Fancy Box js -->
    <script src="assets/js/fancybox.umd.js"></script>
    <!-- Odometer js -->
    <script src="assets/js/odometer.min.js"></script>

    <!-- main js -->
    <script src="assets/js/main.js"></script>
<script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"3c29d7bffb424472bfac70b0302e98df","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>
</body>


<!-- Mirrored from photoclerks.com/html/xtrady-update/xtrady/index.html by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 31 Jan 2026 19:51:08 GMT -->
</html>