<?php session_start();

?>
<!DOCTYPE html>
<html lang="en">


<?php include("includes/head.php")?>


<body>

    <!--==========================   Preloader Start  ==========================-->
    
    <!--==========================  Preloader End  ==========================-->

    <div class="wrapper">
        <!--==========================   Header Start  ==========================-->
            <?php include("includes/header.php") ?>

        <!--==========================  Header End  ==========================-->
        <main>
    <!-- ==================== Breadcrumb Start Here ==================== -->
    <section class="breadcrumb">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="breadcrumb__wrapper">
                        <h2 class="breadcrumb__title">AI Trading Bot Plans</h2>
                        <ul class="breadcrumb__list">
                            <li class="breadcrumb__item"><a href="index.php" class="breadcrumb__link"> 
                                <i class="las la-home"></i> Home</a> 
                            </li>
                            <li class="breadcrumb__item"><i class="fa-solid fa-minus"></i></li>
                            <li class="breadcrumb__item"> 
                                <span class="breadcrumb__item-text"> AI Bot Pricing</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ==================== Breadcrumb End Here ==================== -->
    
    <!--==========================  AI Bot Pricing Section Start  ==========================-->
    <section class="pricing-section bg--black-two py-120">
        <div class="container position-relative">
            <div class="pricing-shape d-none d-lg-block">
                <img src="assets/svg/analysis-1.svg" alt="star">
                <img src="assets/svg/analysis-2.svg" alt="star">
            </div>
            <div class="row row-gap-3 ">
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <h6 class="right-reveal">AI Bot Subscription</h6>
                        <h2 class="mb-0 right-reveal">Choose Your AI Trading Bot</h2>
                    </div>
                </div>
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <p class="right-reveal">No trading knowledge required! Select from our AI bot plans. Each bot trades automatically 24/7. Just fund your account and watch the profits grow.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60 row-gap-4 justify-content-center">
                <?php
                // Fetch AI bot plans from database
                $bot_plans_query = mysqli_query($conn, "
                    SELECT * FROM trading_bot_plans 
                    WHERE is_active = 1 
                    ORDER BY sort_order ASC
                ");
                
                while($plan = mysqli_fetch_assoc($bot_plans_query)):
                    // Calculate monthly profit based on daily ROI
                    $monthly_profit = ($plan['daily_roi_percentage'] * 30);
                ?>
                <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                    <div class="pricing-content">
                        <div class="pricing-header">
                            <h6 class="mb-2"><?php echo htmlspecialchars($plan['plan_name']); ?></h6>
                            <h2 class="mb-2">$<?php echo number_format($plan['subscription_fee'], 0); ?><sub class="fs-16 fw-normal">/Month</sub></h2>
                            <p class="text-success fw-bold"><?php echo $plan['daily_roi_percentage']; ?>% Daily ROI</p>
                        </div>
                        <div class="pricing-body">
                            <ul>
                                <li><strong>Monthly Profit:</strong> ~<?php echo number_format($monthly_profit, 1); ?>%</li>
                                <li><strong>Accuracy:</strong> <?php echo $plan['trading_accuracy']; ?>%</li>
                                <li><strong>Markets Covered:</strong> <?php echo $plan['markets_covered']; ?>+</li>
                                <li><strong>Min Balance:</strong> $<?php echo number_format($plan['min_trading_balance'], 0); ?></li>
                                <?php if($plan['max_trading_balance']): ?>
                                <li><strong>Max Balance:</strong> $<?php echo number_format($plan['max_trading_balance'], 0); ?></li>
                                <?php endif; ?>
                                <li><strong>Support:</strong> <?php echo $plan['support_level']; ?></li>
                                <?php if($plan['has_machine_learning']): ?>
                                <li><i class="fa-solid fa-check text-success me-2"></i> Machine Learning</li>
                                <?php endif; ?>
                                <?php if($plan['has_multi_market']): ?>
                                <li><i class="fa-solid fa-check text-success me-2"></i> Multi-Market Scanning</li>
                                <?php endif; ?>
                                <?php if($plan['has_dedicated_manager']): ?>
                                <li><i class="fa-solid fa-check text-success me-2"></i> Dedicated Manager</li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <a href="register.php?plan=<?php echo $plan['id']; ?>" class="btn btn--black-two">
                                <i class="fa-solid fa-robot me-2"></i>
                                Subscribe Now
                            </a>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                
                <!-- Free Trial Plan -->
                <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                    <div class="pricing-content" style="border: 2px solid #0d6efd;">
                        <div class="pricing-header">
                            <h6 class="mb-2">Free Trial</h6>
                            <h2 class="mb-2">$0<sub class="fs-16 fw-normal">/7 Days</sub></h2>
                            <p class="text-primary fw-bold">Try AI Alpha Bot Free</p>
                        </div>
                        <div class="pricing-body">
                            <ul>
                                <li><strong>Trial Period:</strong> 7 Days Free</li>
                                <li><strong>Daily ROI:</strong> 12.5% (Demo)</li>
                                <li><strong>Accuracy:</strong> 88%</li>
                                <li><strong>Demo Balance:</strong> $1,000 Virtual</li>
                                <li><strong>Markets:</strong> 2 Covered</li>
                                <li><strong>Support:</strong> Email Only</li>
                                <li><i class="fa-solid fa-check text-success me-2"></i> No Credit Card Required</li>
                                <li><i class="fa-solid fa-check text-success me-2"></i> Cancel Anytime</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <a href="register.php?trial=1" class="btn btn-primary">
                                <i class="fa-solid fa-play-circle me-2"></i>
                                Start Free Trial
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Additional Pricing Info -->
            <div class="row mt-5">
                <div class="col-12">
                    <div class="pricing-features bg-dark p-4 rounded">
                        <h4 class="text-center mb-4">All AI Bot Plans Include:</h4>
                        <div class="row">
                            <div class="col-md-4 text-center mb-3">
                                <i class="fa-solid fa-robot fa-2x text--base mb-2"></i>
                                <h6>24/7 Automated Trading</h6>
                                <p class="small">Bots trade while you sleep</p>
                            </div>
                            <div class="col-md-4 text-center mb-3">
                                <i class="fa-solid fa-shield-halved fa-2x text--base mb-2"></i>
                                <h6>Built-in Risk Management</h6>
                                <p class="small">Automatic stop-loss protection</p>
                            </div>
                            <div class="col-md-4 text-center mb-3">
                                <i class="fa-solid fa-chart-line fa-2x text--base mb-2"></i>
                                <h6>Real-time Performance Tracking</h6>
                                <p class="small">Monitor profits 24/7</p>
                            </div>
                            <div class="col-md-4 text-center mb-3">
                                <i class="fa-solid fa-money-bill-transfer fa-2x text--base mb-2"></i>
                                <h6>Daily Profit Withdrawals</h6>
                                <p class="small">Withdraw profits anytime</p>
                            </div>
                            <div class="col-md-4 text-center mb-3">
                                <i class="fa-solid fa-mobile-screen fa-2x text--base mb-2"></i>
                                <h6>Mobile & Web Access</h6>
                                <p class="small">Trade from anywhere</p>
                            </div>
                            <div class="col-md-4 text-center mb-3">
                                <i class="fa-solid fa-lock fa-2x text--base mb-2"></i>
                                <h6>Secure & Insured Funds</h6>
                                <p class="small">Bank-level security</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  AI Bot Pricing Section End  ==========================-->
    
    <!--==========================  Faq Section Start  ==========================-->
    <section class="faq-section bg--black py-120">
        <div class="container position-relative">
            <div class="faq-shape d-none d-lg-block">
                <img src="assets/svg/bank.svg" alt="bank">
                <img src="assets/svg/balance-5.svg" alt="balance">
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-8">
                    <div class="section-content text-center">
                        <h6 class="top-reveal">Bot Pricing FAQs</h6>
                        <h2 class="top-reveal">Common Questions About AI Bot Pricing</h2>
                        <p class="top-reveal">Get answers to frequently asked questions about bot subscriptions, fees, and profit expectations.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60 row-gap-5">
                <div class="col-lg-6 align-self-center">
                    <img src="assets/images/faq/faq.png" alt="AI Bot Pricing FAQ" class="img-fluid scaleUp">
                </div>
                <div class="col-lg-6 align-self-center">
                    <?php
                    // Fetch FAQ items related to pricing and bots
                    $faq_query = mysqli_query($conn, "
                        SELECT fi.* 
                        FROM faq_items fi 
                        WHERE fi.is_active = 1 
                        AND fi.id IN (36, 37, 38, 39, 40, 41, 42, 43, 44, 45)
                        ORDER BY FIELD(fi.id, 36, 37, 38, 39, 40)
                        LIMIT 5
                    ");
                    $faq_count = 0;
                    ?>
                    <div class="accordion custom--accordion" id="faqExample">
                        <?php while($faq = mysqli_fetch_assoc($faq_query)): 
                            $faq_count++;
                            $active = $faq_count == 1 ? 'show' : '';
                            $collapsed = $faq_count == 1 ? '' : 'collapsed';
                        ?>
                        <div class="accordion-item bottom-reveal">
                            <h2 class="accordion-header">
                                <button class="accordion-button <?php echo $collapsed; ?>" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#faq<?php echo $faq_count; ?>" 
                                    aria-expanded="<?php echo $faq_count == 1 ? 'true' : 'false'; ?>">
                                    <?php echo htmlspecialchars($faq['question']); ?>
                                </button>
                            </h2>
                            <div id="faq<?php echo $faq_count; ?>" class="accordion-collapse collapse <?php echo $active; ?>" data-bs-parent="#faqExample">
                                <div class="accordion-body">
                                    <?php echo $faq['answer']; ?>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="text-center mt-4">
                        <a href="faq.php" class="btn btn--base-two">
                            View All Bot FAQs <i class="flaticon-arrow-upper-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Faq Section End  ==========================-->
    
    <!--==========================  Testimonial Section Start  ==========================-->
    <section class="testimonial-section bg--black-two py-120">
        <div class="container position-relative">
            <div class="testimonial-shape d-none d-lg-block">
                <img src="assets/svg/twostar.svg" alt="star">
                <img src="assets/svg/maneyPlant.svg" alt="money Plant">
            </div>
            <div class="row row-gap-2">
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <h6 class="right-reveal">Bot Success Stories</h6>
                        <h2 class="mb-2 right-reveal">See What Our AI Traders Achieved</h2>
                    </div>
                </div>
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <p class="right-reveal">Real traders with zero experience making consistent profits. The AI does all the work - you just collect the returns.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60">
                <div class="col-12 position-relative bottom-reveal">
                    <div class="testimonial-slide swiper">
                        <div class="swiper-wrapper">
                            <?php
                            // Fetch testimonials from database
                            $testimonials_query = mysqli_query($conn, "
                                SELECT * FROM testimonials 
                                WHERE is_active = 1 
                                ORDER BY RAND()
                                LIMIT 5
                            ");
                            
                            while($testimonial = mysqli_fetch_assoc($testimonials_query)):
                                // Generate star rating
                                $stars = '';
                                for($i = 1; $i <= 5; $i++) {
                                    $stars .= $i <= $testimonial['rating'] 
                                        ? '<i class="fas fa-star text-warning"></i>' 
                                        : '<i class="far fa-star text-warning"></i>';
                                }
                            ?>
                            <div class="swiper-slide">
                                <div class="testimonial-item">
                                    <div class="start-client">
                                        <div class="star-rating mb-2">
                                            <?php echo $stars; ?>
                                        </div>
                                    </div>
                                    <div class="client-body">
                                        <img src="assets/svg/quite.svg" alt="quote">
                                        <p class="client-text">
                                            "<?php echo htmlspecialchars($testimonial['testimonial_text']); ?>"
                                        </p>
                                        <div class="client-info d-flex gap-3 align-self-center">
                                            <img src="assets/images/client/<?php echo htmlspecialchars($testimonial['avatar']); ?>" alt="<?php echo htmlspecialchars($testimonial['full_name']); ?>">
                                            <div class="text">
                                                <h4 class="mb-2"><?php echo htmlspecialchars($testimonial['full_name']); ?></h4>
                                                <p><?php echo htmlspecialchars($testimonial['profession']); ?></p>
                                                <?php if($testimonial['bot_plan']): ?>
                                                <small class="text-muted">
                                                    <i class="fa-solid fa-robot me-1"></i>
                                                    <?php echo htmlspecialchars($testimonial['bot_plan']); ?>
                                                    <?php if($testimonial['profit_made']): ?>
                                                    • <?php echo htmlspecialchars($testimonial['profit_made']); ?>
                                                    <?php endif; ?>
                                                    <?php if($testimonial['time_period']): ?>
                                                    in <?php echo htmlspecialchars($testimonial['time_period']); ?>
                                                    <?php endif; ?>
                                                </small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                    <div class="slider-btn">
                        <div class="btn-slider-prev testi-prev">
                            <i class="fa-solid fa-chevron-left"></i>
                        </div>
                        <div class="btn-slider-next testi-next">
                            <i class="fa-solid fa-chevron-right"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Testimonial Stats -->
            <div class="row mt-5">
                <div class="col-12">
                    <div class="text-center">
                        <?php
                        // Get average ROI from testimonials or calculate
                        $total_users = mysqli_query($conn, "SELECT COUNT(*) as total FROM users")->fetch_assoc()['total'];
                        $active_bots = mysqli_query($conn, "SELECT COUNT(*) as total FROM user_bot_subscriptions WHERE status = 'active'")->fetch_assoc()['total'];
                        ?>
                        <div class="d-flex flex-wrap justify-content-center gap-5">
                            <div class="stat-box">
                                <h3 class="text--base"><?php echo number_format($total_users); ?>+</h3>
                                <p>Active AI Traders</p>
                            </div>
                            <div class="stat-box">
                                <h3 class="text--base"><?php echo number_format($active_bots); ?>+</h3>
                                <p>Active AI Bots</p>
                            </div>
                            <div class="stat-box">
                                <h3 class="text--base">12-25%</h3>
                                <p>Average Monthly ROI</p>
                            </div>
                            <div class="stat-box">
                                <h3 class="text--base">24/7</h3>
                                <p>Trading Uptime</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Testimonial Section End  ==========================-->
    
    <!--==========================  Call-to-action Section Start  ==========================-->
    <section class="call-to-action-section bg--black-two">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="call-action-box">
                        <div class="call-shape">
                            <img src="assets/svg/twostar.svg" alt="star">
                        </div>
                        <div class="row row-gap-5">
                            <div class="col-lg-6 align-self-center order-1 order-lg-0">
                                <div class="call-text text-center text-lg-start">
                                    <span class="text--base pb-3 right-reveal">Ready to Start AI Trading?</span>
                                    <h2 class="mb-4 right-reveal">Try Any AI Bot Free for 7 Days - No Credit Card Required</h2>
                                    <div class="d-flex flex-wrap gap-3">
                                        <a href="register.php?trial=1" class="btn btn--base-two right-reveal">
                                            <i class="fa-solid fa-play-circle me-2"></i>
                                            Start Free Trial
                                        </a>
                                        <a href="register.php" class="btn btn-outline--base right-reveal">
                                            <i class="fa-solid fa-robot me-2"></i>
                                            Subscribe Now
                                        </a>
                                    </div>
                                    <p class="mt-3 small">No trading knowledge needed • AI bots do all the work • Daily profit withdrawals</p>
                                </div>
                            </div>
                            <div class="col-lg-6 align-self-center">
                                <div class="call-img text-lg-end text-center scaleUp">
                                    <img src="assets/images/call/call-img.png" alt="AI Trading Bots" class="img-fluid m-auto">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Call-to-action Section End  ==========================-->
</main>
   
        <!-- ==================== Footer Start Here ==================== -->
       <?php include("includes/footer.php") ?>
        <!-- ==================== Footer End Here ==================== -->
    </div>
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <style>
        /* Pricing Features Box */
.pricing-features {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.pricing-features h4 {
    color: #fff;
}

/* Stat Boxes */
.stat-box {
    text-align: center;
    padding: 15px 25px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 10px;
    min-width: 150px;
}

.stat-box h3 {
    font-size: 32px;
    font-weight: bold;
    margin-bottom: 5px;
}

.stat-box p {
    color: #aaa;
    margin-bottom: 0;
    font-size: 14px;
}

/* Free Trial Plan Styling */
.pricing-content[style*="border: 2px solid #0d6efd"] {
    position: relative;
    overflow: hidden;
}

.pricing-content[style*="border: 2px solid #0d6efd"]::before {
    content: "POPULAR";
    position: absolute;
    top: 15px;
    right: -30px;
    background: #0d6efd;
    color: white;
    padding: 5px 30px;
    font-size: 12px;
    font-weight: bold;
    transform: rotate(45deg);
}

/* Check marks in pricing lists */
.pricing-body ul li i.fa-check {
    color: #10b981;
}

/* Profit display */
.text-success.fw-bold {
    color: #10b981 !important;
    font-size: 18px;
}
    </style>


    <!-- Jquery js -->
    <script data-cfasync="false" src="../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- gsap Js -->
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <!-- Bootstrap Bundle Js -->
    <script src="assets/js/boostrap.bundle.min.js"></script>
    <!-- Scroll Reveal Js -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <!-- Swiper Bundle Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Fancy Box js -->
    <script src="assets/js/fancybox.umd.js"></script>
    <!-- Odometer js -->
    <script src="assets/js/odometer.min.js"></script>

    <!-- main js -->
    <script src="assets/js/main.js"></script>
<script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"3c29d7bffb424472bfac70b0302e98df","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>
</body>


<!-- Mirrored from photoclerks.com/html/xtrady-update/xtrady/support.html by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 31 Jan 2026 19:52:33 GMT -->
</html>