<?php
// admin_mailer.php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require_once '../mail/Exception.php';
require_once '../mail/PHPMailer.php';
require_once '../mail/SMTP.php';

// Your email configuration
$myHost = $mailer['host'];
$myPort = $mailer['port'];
$host_email = $mailer['username'];
$host_pass = $mailer['password'];

// User data
$user_email = $email;
$first_name = $first_name;

$mail = new PHPMailer;
$mail->isSMTP();
$mail->Host = $myHost;
$mail->Port = $myPort;
$mail->SMTPDebug = 0;
$mail->SMTPAuth = true;
$mail->Usefirst_name = $host_email;
$mail->Password = $host_pass;
$mail->setFrom($host_email, $sitename);
$mail->addAddress($user_email, $first_name);

if ($mail->addReplyTo($host_email, $sitename)) {
    $mail->Subject = $mail_subject . ' - ' . $sitename;
    $mail->isHTML(true);    
    $mail->Body = "
<!DOCTYPE html>
    <html lang='en' xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'>
    <head>
        <meta charset='utf-8'>
        <meta name='viewport' content='width=device-width,initial-scale=1'>
        <meta name='x-apple-disable-message-reformatting'>
        <meta name='format-detection' content='telephone=no,date=no,address=no,email=no,url=no'>
        <title>Email Verification</title>
        <!--[if mso]>
        <xml>
            <o:OfficeDocumentSettings>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
        <![endif]-->
        <style>
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
            body {
                font-family: 'Segoe UI', Arial, sans-serif;
                background-color: #f8f9fa;
                color: #333333;
                line-height: 1.6;
            }
            .email-container {
                max-width: 600px;
                margin: 0 auto;
                background: #ffffff;
                border-radius: 12px;
                overflow: hidden;
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            }
            .email-header {
                background: linear-gradient(135deg, #000000 0%, #1a1a1a 50%, #198754 100%);
                padding: 40px 30px;
                text-align: center;
                border-bottom: 4px solid #198754;
            }
            .logo {
                max-width: 180px;
                height: auto;
                margin-bottom: 20px;
            }
            .email-title {
                color: #ffffff;
                font-size: 28px;
                font-weight: 700;
                margin-bottom: 10px;
                letter-spacing: -0.5px;
            }
            .email-subtitle {
                color: #e9ecef;
                font-size: 16px;
                font-weight: 400;
                opacity: 0.9;
            }
            .email-content {
                padding: 40px 30px;
            }
            .greeting {
                font-size: 20px;
                font-weight: 600;
                color: #2b2b2b;
                margin-bottom: 20px;
            }
            .user-name {
                color: #198754;
                font-weight: 700;
            }
            .message {
                font-size: 16px;
                color: #555555;
                margin-bottom: 30px;
                line-height: 1.7;
            }
            .verification-section {
                background: #f8f9fa;
                border-radius: 8px;
                padding: 25px;
                margin: 30px 0;
                border-left: 4px solid #198754;
            }
            .verification-button {
                display: inline-block;
                background: linear-gradient(135deg, #198754 0%, #157347 100%);
                color: #ffffff !important;
                text-decoration: none;
                padding: 16px 40px;
                border-radius: 8px;
                font-weight: 600;
                font-size: 16px;
                text-align: center;
                transition: all 0.3s ease;
                box-shadow: 0 4px 15px rgba(25, 135, 84, 0.3);
            }
            .verification-button:hover {
                background: linear-gradient(135deg, #157347 0%, #0f5132 100%);
                transform: translateY(-2px);
                box-shadow: 0 6px 20px rgba(25, 135, 84, 0.4);
            }
            .link-alternative {
                background: #ffffff;
                border: 1px solid #e9ecef;
                border-radius: 6px;
                padding: 15px;
                margin: 20px 0;
                word-break: break-all;
            }
            .verification-link {
                color: #198754;
                text-decoration: none;
                font-size: 14px;
                font-weight: 500;
            }
            .security-notice {
                background: #fff3cd;
                border: 1px solid #ffeaa7;
                border-radius: 6px;
                padding: 15px;
                margin: 25px 0;
            }
            .security-title {
                color: #856404;
                font-weight: 600;
                margin-bottom: 8px;
                font-size: 14px;
            }
            .security-text {
                color: #856404;
                font-size: 13px;
                line-height: 1.5;
            }
            .expiry-notice {
                background: #d1ecf1;
                border: 1px solid #bee5eb;
                border-radius: 6px;
                padding: 12px 15px;
                margin: 20px 0;
            }
            .expiry-text {
                color: #0c5460;
                font-size: 13px;
                font-weight: 500;
            }
            .support-section {
                text-align: center;
                margin: 30px 0 20px 0;
                padding: 20px;
                background: #f8f9fa;
                border-radius: 8px;
            }
            .support-text {
                color: #6c757d;
                font-size: 14px;
                margin-bottom: 10px;
            }
            .support-link {
                color: #198754;
                text-decoration: none;
                font-weight: 600;
            }
            .email-footer {
                background: #1a1a1a;
                padding: 30px;
                text-align: center;
                border-top: 4px solid #198754;
            }
            .footer-text {
                color: #adb5bd;
                font-size: 12px;
                line-height: 1.6;
                margin-bottom: 10px;
            }
            .footer-link {
                color: #198754;
                text-decoration: none;
            }
            .copyright {
                color: #6c757d;
                font-size: 11px;
                margin-top: 15px;
            }
            @media only screen and (max-width: 600px) {
                .email-container {
                    margin: 10px;
                    border-radius: 8px;
                }
                .email-header {
                    padding: 30px 20px;
                }
                .email-content {
                    padding: 30px 20px;
                }
                .email-title {
                    font-size: 24px;
                }
                .verification-button {
                    padding: 14px 30px;
                    font-size: 15px;
                }
            }
        </style>
    </head>
    <body>
        <div class='email-container'>
            <!-- Header Section -->
            <div class='email-header'>
                <img src='".$myUrl."/images/".$sitelogo."' alt='".$sitename."' class='logo' />
                <h1 class='email-title'>Email Verification Required</h1>
                <p class='email-subtitle'>Complete your registration with ".$sitename."</p>
            </div>

            ".$mail_message."

            <!-- Footer Section -->
            <div class='email-footer'>
                <p class='footer-text'>
                    <strong>".$sitename."</strong><br>
                    Professional Financial Services
                </p>
                <p class='footer-text'>
                    <a href='".$myUrl."' class='footer-link'>Visit Our Website</a> | 
                    <a href='".$myUrl."/privacy.php' class='footer-link'>Privacy Policy</a> | 
                    <a href='".$myUrl."/terms.php' class='footer-link'>Terms of Service</a>
                </p>
                <p class='copyright'>
                    &copy; ".date('Y')." ".$sitename.". All rights reserved.<br>
                    This is an automated message, please do not reply directly to this email.
                </p>
            </div>
        </div>
    </body>
    </html>";

   
        $mail->send();
        // Success message handling removed as per request
        
    
}
?>