<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set content type to JSON
header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get form data
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $subject = trim($_POST['subject']);
    $message = trim($_POST['message']);

    // Validate required fields
    if (empty($name) || empty($email) || empty($phone) || empty($subject) || empty($message)) {
        echo json_encode(['success' => false, 'message' => 'All fields are required.']);
        exit;
    }

    // Validate email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'message' => 'Please provide a valid email address.']);
        exit;
    }

    // Validate phone (basic validation)
    if (strlen($phone) < 5) {
        echo json_encode(['success' => false, 'message' => 'Please provide a valid phone number.']);
        exit;
    }

    // Company details
    $company_email = "info@efina.co.za"; // Your company email
    $company_name = "E-Finance Loans";
    $site_name = "E-Finance Loans";

    // Email to company
    $company_subject = "New Contact Form Submission: " . $subject;
    $company_message = "
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; background: #f4f4f4; padding: 20px; }
            .container { max-width: 600px; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
            .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 8px; text-align: center; }
            .content { padding: 20px 0; }
            .detail-box { background: #f8f9fa; padding: 15px; border-radius: 8px; margin: 10px 0; }
            .footer { text-align: center; padding: 20px; color: #6c757d; font-size: 12px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h2>New Contact Form Submission</h2>
            </div>
            <div class='content'>
                <p>You have received a new message from your website contact form.</p>
                
                <div class='detail-box'>
                    <h3>Contact Details:</h3>
                    <p><strong>Name:</strong> {$name}</p>
                    <p><strong>Email:</strong> {$email}</p>
                    <p><strong>Phone:</strong> {$phone}</p>
                    <p><strong>Subject:</strong> {$subject}</p>
                </div>
                
                <div class='detail-box'>
                    <h3>Message:</h3>
                    <p>{$message}</p>
                </div>
                
                <p><strong>Submission Time:</strong> " . date('Y-m-d H:i:s') . "</p>
                <p><strong>IP Address:</strong> {$_SERVER['REMOTE_ADDR']}</p>
            </div>
            <div class='footer'>
                <p>This email was sent from your website contact form.</p>
            </div>
        </div>
    </body>
    </html>";

    // Email to user (confirmation)
    $user_subject = "Thank You for Contacting $site_name";
    $user_message = "
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; background: #f4f4f4; padding: 20px; }
            .container { max-width: 600px; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
            .header { background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; padding: 20px; border-radius: 8px; text-align: center; }
            .content { padding: 20px 0; }
            .detail-box { background: #f8f9fa; padding: 15px; border-radius: 8px; margin: 10px 0; }
            .footer { text-align: center; padding: 20px; color: #6c757d; font-size: 12px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h2>Thank You for Contacting Us!</h2>
            </div>
            <div class='content'>
                <p>Dear <strong>{$name}</strong>,</p>
                
                <p>Thank you for reaching out to <strong>{$site_name}</strong>. We have received your message and our team will get back to you within 24-48 hours.</p>
                
                <div class='detail-box'>
                    <h3>Your Message Details:</h3>
                    <p><strong>Subject:</strong> {$subject}</p>
                    <p><strong>Message:</strong> {$message}</p>
                    <p><strong>Submitted:</strong> " . date('Y-m-d H:i:s') . "</p>
                </div>
                
                <p>If you have any urgent inquiries, please feel free to contact us directly at:</p>
                <p>📧 Email: {$company_email}</p>
                <p>📞 Phone: +27 73 374 1106</p>
                
                <p>Best regards,<br><strong>The {$site_name} Team</strong></p>
            </div>
            <div class='footer'>
                <p>This is an automated response. Please do not reply to this email.</p>
            </div>
        </div>
    </body>
    </html>";

    // Email headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: $site_name <noreply@efina.co.za>" . "\r\n";
    $headers .= "Reply-To: $company_email" . "\r\n";

    // Send email to company
    $company_mail_sent = mail($company_email, $company_subject, $company_message, $headers);

    // Send confirmation email to user
    $user_headers = $headers;
    $user_headers .= "Reply-To: $company_email" . "\r\n";
    $user_mail_sent = mail($email, $user_subject, $user_message, $user_headers);

    if ($company_mail_sent && $user_mail_sent) {
        echo json_encode([
            'success' => true, 
            'message' => 'Thank you for your message! We have sent a confirmation email to your inbox and will get back to you soon.'
        ]);
    } elseif ($company_mail_sent) {
        echo json_encode([
            'success' => true, 
            'message' => 'Thank you for your message! We have received your inquiry and will get back to you soon.'
        ]);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => 'Sorry, there was an error sending your message. Please try again or contact us directly.'
        ]);
    }

} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}
?>