<?php session_start();

?>
<!DOCTYPE html>
<html lang="en">


<?php include("includes/head.php")?>


<body>

    <!--==========================   Preloader Start  ==========================-->
    
    <!--==========================  Preloader End  ==========================-->

    <div class="wrapper">
        <!--==========================   Header Start  ==========================-->
            <?php include("includes/header.php") ?>

        <!--==========================  Header End  ==========================-->
       
        <main>
            <!-- ==================== Breadcrumb Start Here ==================== -->
            <section class="breadcrumb">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="breadcrumb__wrapper">
                                <h2 class="breadcrumb__title">Our AI Trading Services</h2>
                                <ul class="breadcrumb__list">
                                    <li class="breadcrumb__item"><a href="index.php" class="breadcrumb__link"> 
                                        <i class="las la-home"></i> Home</a> 
                                    </li>
                                    <li class="breadcrumb__item"><i class="fa-solid fa-minus"></i></li>
                                    <li class="breadcrumb__item"> 
                                        <span class="breadcrumb__item-text"> AI Trading Services</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- ==================== Breadcrumb End Here ==================== -->
            
            <!--==========================  AI Trading Services Section Start  ==========================-->
            <section class="services-section bg--black py-120">
                <div class="container position-relative">
                    <div class="services-two-shape d-none d-lg-block">
                        <img src="assets/svg/balance-1.svg" alt="balance">
                        <img src="assets/svg/balance-2.svg" alt="balance">
                    </div>
                    <div class="row justify-content-center">
                        <div class="col-xl-6 col-lg-8">
                            <div class="section-content text-center">
                                <h6 class="top-reveal">AI Trading Solutions</h6>
                                <h2 class="top-reveal">Fully Automated Trading Services<br class="d-none d-xl-block">Powered by Artificial Intelligence</h2>
                                <p class="top-reveal">No trading knowledge required. Our AI bots handle everything - from market analysis to trade execution. Just fund your account and watch the profits grow automatically.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="row row-gap-4 mt-60">
                        <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-balance-sheet"></i>
                                </div>
                                <h3><a href="services-details.php">AI Alpha Bot</a></h3>
                                <p>Entry-level AI trading bot perfect for beginners. 12.5% daily ROI with 88% accuracy. Minimum balance: $100. No trading experience needed.</p>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-chart"></i>
                                </div>
                                <h3><a href="services-details.php">AI Sigma Bot</a></h3>
                                <p>Advanced machine learning algorithms with 15.2% daily ROI and 92% accuracy. Multi-market analysis. Minimum balance: $500.</p>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-forex"></i>
                                </div>
                                <h3><a href="services-details.php">AI Quantum Bot</a></h3>
                                <p>Professional-grade AI trading with 18.5% daily ROI. Real-time market scanning and arbitrage detection. Minimum balance: $1,000.</p>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-chart-1"></i>
                                </div>
                                <h3><a href="services-details.php">AI Omega Bot</a></h3>
                                <p>Premium AI trading with 22.5% daily ROI and 96% accuracy. Includes dedicated account manager and predictive analytics.</p>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-graph"></i>
                                </div>
                                <h3><a href="services-details.php">Automated Risk Management</a></h3>
                                <p>Our AI systems include built-in risk controls, stop-loss triggers, and portfolio protection. Trade with confidence 24/7.</p>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-md-6 bottom-reveal">
                            <div class="services-box">
                                <div class="icon">
                                    <i class="flaticon-market-analysis"></i>
                                </div>
                                <h3><a href="services-details.php">Performance Analytics</a></h3>
                                <p>Real-time profit tracking, performance reports, and trade history. Monitor your AI bot's performance from anywhere.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--==========================  AI Trading Services Section End  ==========================-->
            
            <!--==========================   Text-slide Start  ==========================-->
            <div class="text-slide-section py-3 bg--base">
                <div class="text-slide swiper">
                    <div class="swiper-wrapper slide-transition">
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-text-black">
                                NO TRADING KNOWLEDGE NEEDED
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-icon">
                                <img src="assets/svg/star-2.svg" alt="star">
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-text-black">
                                24/7 AUTOMATED TRADING
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-icon">
                                <img src="assets/svg/star-2.svg" alt="star">
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-text-black">
                                AI-POWERED PROFITS
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-icon">
                                <img src="assets/svg/star-2.svg" alt="star">
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-text-black">
                                INSTANT WITHDRAWALS
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-icon">
                                <img src="assets/svg/star-2.svg" alt="star">
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-text-black">
                                BUILT-IN RISK MANAGEMENT
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-icon">
                                <img src="assets/svg/star-2.svg" alt="star">
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-text-black">
                                REAL-TIME ANALYTICS
                            </div>
                        </div>
                        <div class="swiper-slide inner-slide-element">
                            <div class="slide-icon">
                                <img src="assets/svg/star-2.svg" alt="star">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--==========================  Text-slide End  ==========================-->
            
            <!--==========================  Faq Section Start  ==========================-->
            <section class="faq-section bg--black py-120">
                <div class="container position-relative">
                    <div class="faq-shape d-none d-lg-block">
                        <img src="assets/svg/bank.svg" alt="bank">
                        <img src="assets/svg/balance-5.svg" alt="balance">
                    </div>
                    <div class="row justify-content-center">
                        <div class="col-xl-7 col-lg-8">
                            <div class="section-content text-center">
                                <h6 class="top-reveal">AI Trading FAQs</h6>
                                <h2 class="top-reveal">Common Questions About AI Trading</h2>
                                <p class="top-reveal">Get answers to frequently asked questions about how our AI trading bots work, funding requirements, and profit expectations.</p>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-60 row-gap-5">
                        <div class="col-lg-6 align-self-center">
                            <img src="assets/images/faq/faq.png" alt="AI Trading FAQs" class="img-fluid scaleUp">
                        </div>
                        <div class="col-lg-6 align-self-center">
                            <?php
                            // Fetch FAQ items related to trading bots
                            $faq_query = mysqli_query($conn, "
                                SELECT fi.* 
                                FROM faq_items fi 
                                WHERE fi.is_active = 1 
                                AND fi.id IN (36, 37, 38, 39, 40)
                                ORDER BY FIELD(fi.id, 36, 37, 38, 39, 40)
                            ");
                            $faq_count = 0;
                            ?>
                            <div class="accordion custom--accordion" id="faqExample">
                                <?php while($faq = mysqli_fetch_assoc($faq_query)): 
                                    $faq_count++;
                                    $active = $faq_count == 1 ? 'show' : '';
                                    $collapsed = $faq_count == 1 ? '' : 'collapsed';
                                ?>
                                <div class="accordion-item bottom-reveal">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button <?php echo $collapsed; ?>" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#faq<?php echo $faq_count; ?>" 
                                            aria-expanded="<?php echo $faq_count == 1 ? 'true' : 'false'; ?>">
                                            <?php echo htmlspecialchars($faq['question']); ?>
                                        </button>
                                    </h2>
                                    <div id="faq<?php echo $faq_count; ?>" class="accordion-collapse collapse <?php echo $active; ?>" data-bs-parent="#faqExample">
                                        <div class="accordion-body">
                                            <?php echo $faq['answer']; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                            </div>
                            <div class="text-center mt-4">
                                <a href="faq.php" class="btn btn--base-two">
                                    View All FAQs <i class="flaticon-arrow-upper-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--==========================  Faq Section End  ==========================-->
            
            <!--==========================  Testimonial Section Start  ==========================-->
            <section class="testimonial-section bg--black-two py-120">
                <div class="container position-relative">
                    <div class="testimonial-shape d-none d-lg-block">
                        <img src="assets/svg/twostar.svg" alt="star">
                        <img src="assets/svg/maneyPlant.svg" alt="money Plant">
                    </div>
                    <div class="row row-gap-2">
                        <div class="col-lg-6 align-self-end">
                            <div class="section-content">
                                <h6 class="right-reveal">Success Stories</h6>
                                <h2 class="mb-2 right-reveal">Real Traders, Real Profits</h2>
                            </div>
                        </div>
                        <div class="col-lg-6 align-self-end">
                            <div class="section-content">
                                <p class="right-reveal">Thousands of users with zero trading experience are earning consistent profits with our AI bots. The AI does all the work - you just collect the profits.</p>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-60">
                        <div class="col-12 position-relative bottom-reveal">
                            <div class="testimonial-slide swiper">
                                <div class="swiper-wrapper">
                                    <?php
                                    // Fetch testimonials from database
                                    $testimonials_query = mysqli_query($conn, "
                                        SELECT * FROM testimonials 
                                        WHERE is_active = 1 
                                        ORDER BY sort_order ASC
                                        LIMIT 5
                                    ");
                                    
                                    while($testimonial = mysqli_fetch_assoc($testimonials_query)):
                                        // Generate star rating
                                        $stars = '';
                                        for($i = 1; $i <= 5; $i++) {
                                            $stars .= $i <= $testimonial['rating'] 
                                                ? '<i class="fas fa-star text-warning"></i>' 
                                                : '<i class="far fa-star text-warning"></i>';
                                        }
                                    ?>
                                    <div class="swiper-slide">
                                        <div class="testimonial-item">
                                            <div class="start-client">
                                                <div class="star-rating mb-2">
                                                    <?php echo $stars; ?>
                                                </div>
                                            </div>
                                            <div class="client-body">
                                                <img src="assets/svg/quite.svg" alt="quote">
                                                <p class="client-text">
                                                    "<?php echo htmlspecialchars($testimonial['testimonial_text']); ?>"
                                                </p>
                                                <div class="client-info d-flex gap-3 align-self-center">
                                                    <img src="assets/images/client/<?php echo htmlspecialchars($testimonial['avatar']); ?>" alt="<?php echo htmlspecialchars($testimonial['full_name']); ?>">
                                                    <div class="text">
                                                        <h4 class="mb-2"><?php echo htmlspecialchars($testimonial['full_name']); ?></h4>
                                                        <p><?php echo htmlspecialchars($testimonial['profession']); ?></p>
                                                        <?php if($testimonial['bot_plan']): ?>
                                                        <small class="text-muted">
                                                            <i class="fas fa-robot me-1"></i>
                                                            <?php echo htmlspecialchars($testimonial['bot_plan']); ?>
                                                            <?php if($testimonial['profit_made']): ?>
                                                            • <?php echo htmlspecialchars($testimonial['profit_made']); ?> profit
                                                            <?php endif; ?>
                                                        </small>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                                <div class="swiper-pagination"></div>
                            </div>
                            <div class="slider-btn">
                                <div class="btn-slider-prev testi-prev">
                                    <i class="fa-solid fa-chevron-left"></i>
                                </div>
                                <div class="btn-slider-next testi-next">
                                    <i class="fa-solid fa-chevron-right"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--==========================  Testimonial Section End  ==========================-->
            
            <!--==========================  Call-to-action Section Start  ==========================-->
            <section class="call-to-action-section bg--black-two">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="call-action-box">
                                <div class="call-shape">
                                    <img src="assets/svg/twostar.svg" alt="star">
                                </div>
                                <div class="row row-gap-5">
                                    <div class="col-lg-6 align-self-center order-1 order-lg-0">
                                        <div class="call-text text-center text-lg-start">
                                            <span class="text--base pb-3 right-reveal">Ready to Start AI Trading?</span>
                                            <h2 class="mb-4 right-reveal">Join Thousands Earning Passive Income with Our AI Trading Bots</h2>
                                            <a href="register.php" class="btn btn--base-two right-reveal">
                                                Start Trading Now <i class="flaticon-arrow-upper-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 align-self-center">
                                        <div class="call-img text-lg-end text-center scaleUp">
                                            <img src="assets/images/call/call-img.png" alt="AI Trading Bots" class="img-fluid m-auto">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--==========================  Call-to-action Section End  ==========================-->
        </main>
        <!-- ==================== Footer Start Here ==================== -->
       <?php include("includes/footer.php") ?>
        <!-- ==================== Footer End Here ==================== -->
    </div>
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>


    <!-- Jquery js -->
    <script data-cfasync="false" src="../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- gsap Js -->
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <!-- Bootstrap Bundle Js -->
    <script src="assets/js/boostrap.bundle.min.js"></script>
    <!-- Scroll Reveal Js -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <!-- Swiper Bundle Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Fancy Box js -->
    <script src="assets/js/fancybox.umd.js"></script>
    <!-- Odometer js -->
    <script src="assets/js/odometer.min.js"></script>

    <!-- main js -->
    <script src="assets/js/main.js"></script>
<script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"3c29d7bffb424472bfac70b0302e98df","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>
</body>


<!-- Mirrored from photoclerks.com/html/xtrady-update/xtrady/support.html by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 31 Jan 2026 19:52:33 GMT -->
</html>